/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.ui.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.enablement.oda.ecore.impl.ColumnDefinitionUtil;
import org.eclipse.datatools.enablement.oda.ecore.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ecore.ui.impl.ContainerCheckedGraphViewer;
import org.eclipse.datatools.enablement.oda.ecore.ui.util.PropertiesUtil;
import org.eclipse.datatools.enablement.oda.ecore.util.EPackageUtil;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.tree.impl.TreeNodeImpl;
import org.eclipse.emf.edit.tree.provider.TreeItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataSetColumnsWizardPage
extends DataSetWizardPage {
    private Set<EPackage> ePackages;
    private CheckboxTreeViewer viewer;
    private Properties dataSourceProperties;

    public DataSetColumnsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(Messages.getString("DataSetColumnsWizardPage.message.default"));
        this.setPageComplete(false);
    }

    public DataSetColumnsWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(pageName);
        this.setMessage(Messages.getString("DataSetColumnsWizardPage.message.default"));
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().hint(-1, 100).align(4, 4).applyTo((Control)composite);
        this.viewer = new ContainerCheckedGraphViewer(composite, 2816);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DataSetColumnsWizardPage.this.validateData();
                DataSetColumnsWizardPage.this.savePage(DataSetColumnsWizardPage.this.getEditingDesign());
            }
        });
        this.initializeControls();
        this.setControl((Control)composite);
        GridLayoutFactory.fillDefaults().margins(4, 4).generateLayout(composite);
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.setViewerInputBasedOnInvariant(dataSetDesign);
    }

    private void initializeControls() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        this.dataSourceProperties = DesignUtil.convertDataSourceProperties((DataSourceDesign)dataSetDesign.getDataSourceDesign());
        try {
            this.ePackages = EPackageUtil.getPackagesForModel((Properties)this.dataSourceProperties);
            this.setViewerInputBasedOnInvariant(dataSetDesign);
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                this.setMessage(e.getMessage(), 3);
            } else {
                this.setMessage(String.valueOf(Messages.getString("DataSetColumnsWizardPage.message.loadError")) + cause.getMessage(), 3);
            }
        }
        catch (OdaException odaException) {
            this.setMessage(Messages.getString("DataSetColumnsWizardPage.message.noEPackage"), 3);
        }
    }

    private void setViewerInputBasedOnInvariant(DataSetDesign dataSetDesign) {
        if (dataSetDesign.getPrivateProperties() != null) {
            String invariant = dataSetDesign.getPrivateProperties().getProperty("OCL_ECORE_INVARIANT");
            if (invariant == null || invariant.length() == 0) {
                this.showAllEstructuralFeatures();
            } else {
                ArrayList<EClass> eClassHierarchy = new ArrayList<EClass>();
                for (EPackage ePackage : this.ePackages) {
                    if (!(ePackage.getEClassifier(invariant) instanceof EClass)) continue;
                    EClass invariantEClass = (EClass)ePackage.getEClassifier(invariant);
                    eClassHierarchy.add(invariantEClass);
                    eClassHierarchy.addAll((Collection<EClass>)invariantEClass.getEAllSuperTypes());
                }
                if (eClassHierarchy.isEmpty()) {
                    this.showAllEstructuralFeatures();
                } else {
                    this.viewer.setInput((Object)new TreeViewerBuilder(eClassHierarchy).buildTree());
                }
            }
        } else {
            this.showAllEstructuralFeatures();
        }
        this.initializeCheckedElements(dataSetDesign);
    }

    private void initializeCheckedElements(DataSetDesign dataSetDesign) {
        TreePath[] treePaths;
        TreePath[] treePathArray = treePaths = this.findTreePaths(dataSetDesign.getPrimaryResultSet());
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            this.viewer.reveal((Object)path);
            if (path.getLastSegment() != null) {
                this.viewer.setChecked(path.getLastSegment(), true);
            }
            this.validateData();
            ++n2;
        }
    }

    private TreePath[] findTreePaths(ResultSetDefinition primaryResultSet) {
        if (primaryResultSet == null) {
            return new TreePath[0];
        }
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        ResultSetColumns resultSetColumns = primaryResultSet.getResultSetColumns();
        EList columnDefinitions = resultSetColumns.getResultColumnDefinitions();
        for (ColumnDefinition columnDefinition : columnDefinitions) {
            ENamedElement[] featurePath = ColumnDefinitionUtil.getFeaturePath((ColumnDefinition)columnDefinition, this.ePackages);
            ArrayList<TreeNode> nodePath = new ArrayList<TreeNode>();
            TreeNode currentNode = (TreeNode)this.viewer.getInput();
            int i = 0;
            while (i < featurePath.length) {
                TreeNode newParent = this.findNodeFor(featurePath[i], currentNode);
                nodePath.add(newParent);
                currentNode = newParent;
                ++i;
            }
            treePaths.add(new TreePath(nodePath.toArray()));
        }
        return treePaths.toArray(new TreePath[treePaths.size()]);
    }

    private TreeNode findNodeFor(ENamedElement data, TreeNode parent) {
        EList children = parent.getChildren();
        for (TreeNode treeNode : children) {
            if (!data.getName().equals(((ENamedElement)treeNode.getData()).getName())) continue;
            return treeNode;
        }
        throw new IllegalArgumentException("Unable to locate [" + data + "] in [" + parent.getData() + "].");
    }

    private void showAllEstructuralFeatures() {
        HashSet eClassifiers = new HashSet();
        for (EPackage ePackage : this.ePackages) {
            eClassifiers.addAll(ePackage.getEClassifiers());
        }
        this.viewer.setInput((Object)new TreeViewerBuilder(EcoreUtil.getObjectsByType(eClassifiers, (EClassifier)EcorePackage.Literals.ECLASS)).buildTree());
    }

    private void validateData() {
        boolean aValidColumnIsSelected = this.aValidColumnIsSelected();
        if (aValidColumnIsSelected) {
            this.setMessage(Messages.getString("DataSetColumnsWizardPage.message.default"));
        } else {
            this.setMessage(Messages.getString("DataSetColumnsWizardPage.message.noColumnSelected"), 3);
        }
        this.setPageComplete(aValidColumnIsSelected);
    }

    private boolean aValidColumnIsSelected() {
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            TreeNode node = (TreeNode)checkedElement;
            if (node.getData() instanceof EAttribute || node.getData() instanceof EReference) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setViewerInputBasedOnInvariant(this.getEditingDesign());
        }
        super.setVisible(visible);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.dataSourceProperties == null) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void savePage(DataSetDesign dataSetDesign) {
        if (!this.aValidColumnIsSelected()) {
            dataSetDesign.setResultSets(null);
            return;
        }
        ResultSetColumns newResultSetColumns = DesignFactory.eINSTANCE.createResultSetColumns();
        StringBuilder columns = new StringBuilder();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            TreeNode node = (TreeNode)checkedElement;
            if (node.getData() instanceof EAttribute || node.getData() instanceof EReference && this.noChildrenAreChecked(node)) {
                ColumnDefinition newColumn = ColumnDefinitionUtil.createFor((ENamedElement[])this.getPathTo(node));
                newResultSetColumns.getResultColumnDefinitions().add((Object)newColumn);
                columns.append(newColumn.getAttributes().getName());
                columns.append(',');
            }
            ++n2;
        }
        PropertiesUtil.persistProperty(dataSetDesign, "COLUMN_DEFINITIONS", columns.toString());
        ResultSetDefinition resultSetDefinition = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefinition.setResultSetColumns(newResultSetColumns);
        dataSetDesign.setPrimaryResultSet(resultSetDefinition);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private boolean noChildrenAreChecked(TreeNode node) {
        EList children = node.getChildren();
        for (TreeNode child : children) {
            if (!this.viewer.getChecked((Object)child)) continue;
            return false;
        }
        return true;
    }

    private ENamedElement[] getPathTo(TreeNode treeNode) {
        ArrayList<ENamedElement> namedElements = new ArrayList<ENamedElement>();
        TreeNode visiting = treeNode;
        while (visiting.getData() instanceof ENamedElement) {
            namedElements.add((ENamedElement)visiting.getData());
            visiting = visiting.getParent();
        }
        Collections.reverse(namedElements);
        return namedElements.toArray(new ENamedElement[namedElements.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TreeViewerBuilder {
        private final Collection<EClass> eClasses;
        private TreeNode root;

        TreeViewerBuilder(Collection<EClass> eClasses) {
            this.eClasses = eClasses;
        }

        TreeNode buildTree() {
            for (EClass eClass : this.eClasses) {
                this.getOrCreateRoot().getChildren().add((Object)this.createNodeFor(eClass));
            }
            return this.getOrCreateRoot();
        }

        TreeNode getOrCreateRoot() {
            if (this.root == null) {
                this.root = TreeFactory.eINSTANCE.createTreeNode();
                this.root.setData(EcoreFactory.eINSTANCE.createEObject());
            }
            return this.root;
        }

        private void attach(TreeNode parent, EClass eClass, boolean showAllStructuralFeatures) {
            EList attributes = showAllStructuralFeatures ? eClass.getEAllAttributes() : eClass.getEAttributes();
            for (EAttribute attribute : attributes) {
                this.createNodeFor(attribute).setParent(parent);
            }
            EList references = showAllStructuralFeatures ? eClass.getEAllReferences() : eClass.getEReferences();
            for (EReference reference : references) {
                this.createNodeFor(reference).setParent(parent);
            }
        }

        TreeNode createNodeFor(EClass eClass) {
            LazyNonDispatchingClassNode referenceNode = new LazyNonDispatchingClassNode();
            referenceNode.setData((EObject)eClass);
            return referenceNode;
        }

        TreeNode createNodeFor(EAttribute attribute) {
            NonDispatchingTreeNode attributeNode = new NonDispatchingTreeNode(null, null);
            attributeNode.setData((EObject)attribute);
            return attributeNode;
        }

        TreeNode createNodeFor(EReference reference) {
            LazyNonDispatchingTreeNode referenceNode = new LazyNonDispatchingTreeNode(reference.getEReferenceType());
            referenceNode.setData((EObject)reference);
            return referenceNode;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class LazyNonDispatchingClassNode
        extends NonDispatchingTreeNode {
            private LazyNonDispatchingClassNode() {
            }

            public EList<TreeNode> getChildren() {
                if (this.children == null) {
                    super.getChildren();
                    TreeViewerBuilder.this.attach((TreeNode)this, (EClass)this.getData(), false);
                }
                return super.getChildren();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class LazyNonDispatchingTreeNode
        extends NonDispatchingTreeNode {
            private final EClass eClass;

            LazyNonDispatchingTreeNode(EClass eClass) {
                this.eClass = eClass;
            }

            public EList<TreeNode> getChildren() {
                if (this.children == null) {
                    super.getChildren();
                    TreeViewerBuilder.this.attach((TreeNode)this, this.eClass, true);
                }
                return super.getChildren();
            }
        }

        private static class NonDispatchingTreeNode
        extends TreeNodeImpl {
            private NonDispatchingTreeNode() {
            }

            public NotificationChain basicSetParent(TreeNode newParent, NotificationChain msgs) {
                super.basicSetParent(newParent, msgs);
                return null;
            }

            /* synthetic */ NonDispatchingTreeNode(NonDispatchingTreeNode nonDispatchingTreeNode, NonDispatchingTreeNode nonDispatchingTreeNode2) {
                this();
            }
        }
    }
}

