/*
 * Decompiled with CFR 0.152.
 */
package lpg.lpgjavaruntime;

import java.util.HashMap;
import lpg.lpgjavaruntime.PrsStream;

public abstract class Differ {
    static final int I_CODE = 0;
    static final int D_CODE = 1;
    static final int R_CODE = 2;
    static final int M_CODE = 3;
    static final int MM_CODE = 4;
    static final int IMI_CODE = 5;
    static final int MI_CODE = 6;
    static final int IM_CODE = 7;
    static final int DMD_CODE = 8;
    static final int MD_CODE = 9;
    static final int DM_CODE = 10;
    PrsStream newStream;
    PrsStream oldStream;
    int insertCount = 0;
    int deleteCount = 0;
    int replaceDeleteCount = 0;
    int replaceInsertCount = 0;
    int moveCount = 0;
    Change deleteRoot = null;
    Change insertRoot = null;
    Change replaceRoot = null;
    Change changeRoot = null;
    int changeCount = 0;
    int extraCount = 0;
    int newStart;
    int oldStart;
    int newEnd;
    int oldEnd;
    ILine[] newBuffer;
    ILine[] oldBuffer;
    HashMap newMap = new HashMap();
    int[] newLink;

    public abstract ILine[] getBuffer(PrsStream var1);

    protected Differ() {
    }

    public Differ(PrsStream newStream, PrsStream oldStream) {
        this.newStream = newStream;
        this.oldStream = oldStream;
        this.newBuffer = this.getBuffer(newStream);
        this.oldBuffer = this.getBuffer(oldStream);
        int i = 1;
        while (i < this.newBuffer.length && i < this.oldBuffer.length) {
            if (!this.newBuffer[i].equals(this.oldBuffer[i])) break;
            ++i;
        }
        if (i == this.newBuffer.length && i == this.oldBuffer.length) {
            return;
        }
        this.newStart = i;
        this.oldStart = i;
        i = this.newBuffer.length - 1;
        int k = this.oldBuffer.length - 1;
        while (i > this.newStart && k > this.oldStart) {
            if (!this.newBuffer[i].equals(this.oldBuffer[k])) break;
            --i;
            --k;
        }
        this.newEnd = i;
        this.oldEnd = k;
        this.newLink = new int[this.newBuffer.length];
        int[] tail = new int[this.newBuffer.length];
        i = 1;
        while (i < this.newBuffer.length) {
            ILine line = this.newBuffer[i];
            Integer root = (Integer)this.newMap.get(line);
            if (root == null) {
                root = new Integer(i);
                this.newMap.put(line, root);
            } else {
                this.newLink[tail[root.intValue()]] = i;
            }
            tail[root.intValue()] = i++;
        }
    }

    final int min(int x, int y) {
        return x < y ? x : y;
    }

    public final int getChangeCount() {
        return this.changeCount;
    }

    public final int getInsertCount() {
        return this.insertCount;
    }

    public final int getDeleteCount() {
        return this.deleteCount;
    }

    public final int getReplaceDeleteCount() {
        return this.replaceDeleteCount;
    }

    public final int getReplaceInsertCount() {
        return this.replaceInsertCount;
    }

    public final int getMoveCount() {
        return this.moveCount;
    }

    public void compare() {
        if (this.newLink != null) {
            this.compare(this.oldStart, this.oldEnd, this.newStart, this.newEnd);
            this.findMoves();
            this.mergeChanges();
        }
    }

    public void outputChanges() {
        Change element = this.changeRoot;
        while (element != null) {
            if (element.getCode() == 0) {
                this.outputInsert(element);
            } else if (element.getCode() == 1) {
                this.outputDelete(element);
            } else if (element.getCode() == 2) {
                this.outputReplace(element);
            } else if (element.getCode() == 3) {
                this.outputMove(element);
            } else if (element.getCode() == 9) {
                this.outputMoveDelete(element);
            } else if (element.getCode() == 6) {
                this.outputMoveInsert(element);
            } else {
                System.out.println("Don't know what to do with code " + element.getCode());
            }
            element = element.getNext();
        }
    }

    void detach(ILine[] buffer, HashMap map, int[] link, int start, int end) {
        int k = start;
        while (k <= end) {
            ILine line = buffer[k];
            Integer root = (Integer)map.get(line);
            if (root == null) {
                int previous = 0;
                int i = root;
                while (i != k && i != 0) {
                    previous = i;
                    i = link[i];
                }
                if (previous == 0) {
                    int successor = link[root];
                    if (successor == 0) {
                        map.remove(line);
                    } else {
                        map.put(line, new Integer(successor));
                    }
                } else {
                    link[previous] = link[k];
                }
            }
            ++k;
        }
    }

    boolean compareSections(int olds, int news, int bound) {
        int i = 0;
        while (i <= bound) {
            if (!this.oldBuffer[olds + i].equals(this.newBuffer[news + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void addReplace(int olds, int olde, int news, int newe) {
        ++this.changeCount;
        this.detach(this.newBuffer, this.newMap, this.newLink, news, newe);
        Change element = this.replaceRoot;
        Change tail = null;
        while (element != null) {
            int bound1 = element.getOlde() - element.getOlds();
            int bound2 = element.getNewe() - element.getNews();
            if (bound1 == newe - news && bound2 == olde - olds && this.compareSections(element.getOlds(), news, bound1) && this.compareSections(olds, element.getNews(), bound2)) {
                Change change_element = new Change(3, element.getOlds(), element.getOlde(), news, newe, this.changeCount);
                change_element.setNext(this.changeRoot);
                this.changeRoot = change_element;
                element.setCode(3);
                element.setOlds(olds);
                element.setOlde(olde);
                if (element == this.replaceRoot) {
                    this.replaceRoot = element.getNext();
                } else {
                    tail.setNext(element.getNext());
                }
                element.setNext(this.changeRoot);
                this.changeRoot = element;
                return;
            }
            tail = element;
            element = element.getNext();
        }
        element = new Change(2, olds, olde, news, newe, this.changeCount);
        element.setNext(this.replaceRoot);
        this.replaceRoot = element;
    }

    void findMoves() {
        Change previous_d;
        Change d_element;
        int bound;
        Change i_element = this.insertRoot;
        Change previous_i = null;
        while (i_element != null && this.deleteRoot != null) {
            bound = i_element.getNewe() - i_element.getNews();
            d_element = this.deleteRoot;
            previous_d = null;
            while (d_element != null) {
                if (bound == d_element.getOlde() - d_element.getOlds() && this.similarSections(d_element, i_element)) {
                    if (d_element == this.deleteRoot) {
                        this.deleteRoot = d_element.getNext();
                        break;
                    }
                    previous_d.setNext(d_element.getNext());
                    break;
                }
                previous_d = d_element;
                d_element = d_element.getNext();
            }
            if (i_element.getCode() != 0) {
                if (i_element == this.insertRoot) {
                    this.insertRoot = i_element.getNext();
                } else {
                    previous_i.setNext(i_element.getNext());
                }
                i_element.setNext(this.changeRoot);
                this.changeRoot = i_element;
            }
            previous_i = i_element;
            i_element = i_element.getNext();
        }
        d_element = this.deleteRoot;
        previous_d = null;
        while (d_element != null && this.insertRoot != null) {
            bound = d_element.getOlde() - d_element.getOlds();
            if (bound >= 2) {
                i_element = this.insertRoot;
                while (i_element != null) {
                    if (bound < i_element.getNewe() - i_element.getNews() && this.deleteOverlap(d_element, i_element)) {
                        if (i_element == this.insertRoot) {
                            this.insertRoot = i_element.getNext();
                            break;
                        }
                        previous_i.setNext(i_element.getNext());
                        break;
                    }
                    previous_i = i_element;
                    i_element = i_element.getNext();
                }
                if (d_element.getCode() != 1) {
                    if (d_element == this.deleteRoot) {
                        this.deleteRoot = d_element.getNext();
                    } else {
                        previous_d.setNext(d_element.getNext());
                    }
                    d_element.setNext(this.changeRoot);
                    this.changeRoot = d_element;
                }
            }
            previous_d = d_element;
            d_element = d_element.getNext();
        }
        i_element = this.insertRoot;
        previous_i = null;
        while (i_element != null && this.deleteRoot != null) {
            bound = i_element.getNewe() - i_element.getNews();
            if (bound >= 2) {
                d_element = this.deleteRoot;
                previous_d = null;
                while (d_element != null) {
                    if (bound < d_element.getOlde() - d_element.getOlds() && this.insertOverlap(d_element, i_element)) {
                        if (d_element == this.deleteRoot) {
                            this.deleteRoot = d_element.getNext();
                            break;
                        }
                        previous_d.setNext(d_element.getNext());
                        break;
                    }
                    previous_d = d_element;
                    d_element = d_element.getNext();
                }
            }
            if (i_element.getCode() != 0) {
                if (i_element == this.insertRoot) {
                    this.insertRoot = i_element.getNext();
                } else {
                    previous_i.setNext(i_element.getNext());
                }
                i_element.setNext(this.changeRoot);
                this.changeRoot = i_element;
            }
            previous_i = i_element;
            i_element = i_element.getNext();
        }
    }

    void compare(int olds, int olde, int news, int newe) {
        if (olds > olde && news > newe) {
            return;
        }
        if (olds > olde) {
            ++this.changeCount;
            Change element = new Change(0, olds, olde, news, newe, this.changeCount);
            element.setNext(this.insertRoot);
            this.insertRoot = element;
            this.detach(this.newBuffer, this.newMap, this.newLink, news, newe);
        } else if (news > newe) {
            ++this.changeCount;
            Change element = new Change(1, olds, olde, news, newe, this.changeCount);
            element.setNext(this.deleteRoot);
            this.deleteRoot = element;
        } else {
            int largest = 0;
            int lolds = 0;
            int lnews = 0;
            int oldi = olds;
            while (oldi + largest <= olde) {
                Integer image = (Integer)this.newMap.get(this.oldBuffer[oldi]);
                if (image != null) {
                    int newi = image;
                    while (newi != 0 && oldi + largest <= olde) {
                        if (newi >= news && newi + largest <= newe && this.oldBuffer[oldi + largest].equals(this.newBuffer[newi + largest])) {
                            int bound = this.min(newe - newi, olde - oldi);
                            int i = 1;
                            while (i <= bound) {
                                if (!this.oldBuffer[oldi + i].equals(this.newBuffer[newi + i])) break;
                                ++i;
                            }
                            if (i > largest) {
                                largest = i;
                                lolds = oldi;
                                lnews = newi;
                            }
                        }
                        newi = this.newLink[newi];
                    }
                }
                ++oldi;
            }
            if (largest > 0) {
                this.detach(this.newBuffer, this.newMap, this.newLink, lnews, lnews + largest - 1);
                this.compare(olds, lolds - 1, news, lnews - 1);
                this.compare(lolds + largest, olde, lnews + largest, newe);
            } else {
                this.addReplace(olds, olde, news, newe);
            }
        }
    }

    boolean similarSections(Change d_element, Change i_element) {
        HashMap<ILine, Integer> map = new HashMap<ILine, Integer>();
        int[] link = new int[this.newBuffer.length];
        int[] tail = new int[this.newBuffer.length];
        int bound = d_element.getOlde() - d_element.getOlds();
        if (this.compareSections(d_element.getOlds(), i_element.getNews(), bound)) {
            int i = d_element.getOlds();
            while (i <= d_element.getOlde()) {
                if (this.oldBuffer[i].size() != 0) {
                    i_element.setCode(3);
                    i_element.setOlds(d_element.getOlds());
                    i_element.setOlde(d_element.getOlde());
                    ++this.extraCount;
                    return true;
                }
                ++i;
            }
            return false;
        }
        int i = i_element.getNews();
        while (i <= i_element.getNewe()) {
            ILine line = this.newBuffer[i];
            Integer root = (Integer)map.get(line);
            if (root == null) {
                root = new Integer(i);
                map.put(line, root);
            } else {
                link[tail[root.intValue()]] = i;
            }
            tail[root.intValue()] = i++;
        }
        int largest = -1;
        int newi = 0;
        bound = 0;
        Integer image = (Integer)map.get(this.oldBuffer[d_element.getOlds()]);
        if (image != null) {
            int j = image;
            while (j != 0) {
                bound = i_element.getNewe() - j;
                if (this.compareSections(d_element.getOlds(), j, bound) && bound > largest) {
                    largest = bound;
                    newi = j;
                }
                j = link[j];
            }
        }
        this.detach(this.newBuffer, map, link, i_element.getNews(), i_element.getNewe());
        if (largest >= 0) {
            i_element.setTemp(bound);
            int oldi = d_element.getOlds() + bound + 1;
            bound = d_element.getOlde() - oldi;
            if (this.compareSections(oldi, i_element.getNews(), bound)) {
                i_element.setCode(4);
                i_element.setOlds(d_element.getOlds());
                i_element.setOlde(d_element.getOlde());
                i_element.setTemp(oldi);
                i_element.setTemp2(newi);
                return true;
            }
        }
        return false;
    }

    boolean insertOverlap(Change d_element, Change i_element) {
        HashMap<ILine, Integer> map = new HashMap<ILine, Integer>();
        int[] link = new int[this.oldBuffer.length];
        int[] tail = new int[this.oldBuffer.length];
        int i = d_element.getOlds();
        while (i <= d_element.getOlde()) {
            ILine line = this.oldBuffer[i];
            Integer root = (Integer)map.get(line);
            if (root == null) {
                root = new Integer(i);
                map.put(line, root);
            } else {
                link[tail[root.intValue()]] = i;
            }
            tail[root.intValue()] = i++;
        }
        int oldi = 0;
        int bound = i_element.getNewe() - i_element.getNews();
        Integer image = (Integer)map.get(this.oldBuffer[i_element.getNews()]);
        if (image != null) {
            oldi = image;
            while (oldi != 0) {
                if (d_element.getOlde() - oldi >= bound && this.compareSections(oldi, i_element.getNews(), bound)) break;
                oldi = link[oldi];
            }
        }
        this.detach(this.oldBuffer, map, link, d_element.getOlds(), d_element.getOlde());
        if (oldi != 0) {
            if (oldi == d_element.getOlds()) {
                ++this.extraCount;
                i_element.setCode(9);
            } else if (d_element.getOlde() == oldi + bound) {
                i_element.setCode(10);
            } else {
                i_element.setCode(8);
            }
            i_element.setTemp(oldi);
            i_element.setTemp2(d_element.getNewe());
            i_element.setOlds(d_element.getOlds());
            i_element.setOlde(d_element.getOlde());
            return true;
        }
        return false;
    }

    boolean deleteOverlap(Change d_element, Change i_element) {
        HashMap<ILine, Integer> map = new HashMap<ILine, Integer>();
        int[] link = new int[this.newBuffer.length];
        int[] tail = new int[this.newBuffer.length];
        int i = i_element.getNews();
        while (i <= i_element.getNewe()) {
            ILine line = this.newBuffer[i];
            Integer root = (Integer)map.get(line);
            if (root == null) {
                root = new Integer(i);
                map.put(line, root);
            } else {
                link[tail[root.intValue()]] = i;
            }
            tail[root.intValue()] = i++;
        }
        int bound = d_element.getOlde() - d_element.getOlds();
        int newi = 0;
        Integer image = (Integer)map.get(this.oldBuffer[d_element.getOlds()]);
        if (image != null) {
            newi = image;
            while (newi != 0) {
                if (i_element.getNewe() - newi >= bound && this.compareSections(d_element.getOlds(), newi, bound)) break;
                newi = link[newi];
            }
        }
        this.detach(this.newBuffer, map, link, i_element.getNews(), i_element.getNewe());
        if (newi != 0) {
            if (newi == i_element.getNews()) {
                ++this.extraCount;
                d_element.setCode(6);
            } else if (i_element.getNewe() == newi + bound) {
                d_element.setCode(7);
            } else {
                d_element.setCode(5);
            }
            d_element.setTemp(newi);
            d_element.setTemp2(i_element.getOlde());
            d_element.setNews(i_element.getNews());
            d_element.setNewe(i_element.getNewe());
            return true;
        }
        return false;
    }

    void mergeChanges() {
        Change[] change = new Change[this.changeCount + 1];
        boolean[] slot_used = new boolean[this.changeCount + 1];
        Change element = this.insertRoot;
        while (element != null) {
            change[element.getNumber()] = element;
            slot_used[element.getNumber()] = true;
            element = element.getNext();
        }
        element = this.deleteRoot;
        while (element != null) {
            change[element.getNumber()] = element;
            slot_used[element.getNumber()] = true;
            element = element.getNext();
        }
        element = this.replaceRoot;
        while (element != null) {
            change[element.getNumber()] = element;
            slot_used[element.getNumber()] = true;
            element = element.getNext();
        }
        element = this.changeRoot;
        while (element != null) {
            change[element.getNumber()] = element;
            slot_used[element.getNumber()] = true;
            element = element.getNext();
        }
        this.changeRoot = null;
        int i = this.changeCount;
        while (i >= 1) {
            if (slot_used[i]) {
                Change element2;
                if (change[i].getCode() == 4) {
                    element2 = new Change(3, change[i].getOlds(), change[i].getTemp() - 1, change[i].getTemp2(), change[i].getNewe(), change[i].getNumber());
                    element2.setNext(this.changeRoot);
                    this.changeRoot = element2;
                    change[i].setCode(3);
                    change[i].setOlds(change[i].getTemp());
                    change[i].setNewe(change[i].getTemp2() - 1);
                } else if (change[i].getCode() == 10) {
                    element2 = new Change(3, change[i].getTemp(), change[i].getOlde(), change[i].getNews(), change[i].getNewe(), change[i].getNumber());
                    element2.setNext(this.changeRoot);
                    this.changeRoot = element2;
                    change[i].setCode(1);
                    change[i].setOlde(change[i].getTemp() - 1);
                    change[i].setNewe(change[i].getTemp2());
                } else if (change[i].getCode() == 8) {
                    element2 = new Change(9, change[i].getTemp(), change[i].getOlde(), change[i].getNews(), change[i].getNewe(), change[i].getNumber());
                    element2.setNext(this.changeRoot);
                    this.changeRoot = element2;
                    change[i].setCode(1);
                    change[i].setOlde(change[i].getTemp() - 1);
                    change[i].setNewe(change[i].getTemp2());
                } else if (change[i].getCode() == 7) {
                    element2 = new Change(3, change[i].getOlds(), change[i].getOlde(), change[i].getTemp(), change[i].getNewe(), change[i].getNumber());
                    element2.setNext(this.changeRoot);
                    this.changeRoot = element2;
                    change[i].setCode(0);
                    change[i].setNewe(change[i].getTemp() - 1);
                    change[i].setOlde(change[i].getTemp2());
                } else if (change[i].getCode() == 5) {
                    element2 = new Change(6, change[i].getOlds(), change[i].getOlde(), change[i].getTemp(), change[i].getNewe(), change[i].getNumber());
                    element2.setNext(this.changeRoot);
                    this.changeRoot = element2;
                    change[i].setCode(0);
                    change[i].setNewe(change[i].getTemp() - 1);
                    change[i].setOlde(change[i].getTemp2());
                }
                change[i].setNext(this.changeRoot);
                this.changeRoot = change[i];
            }
            --i;
        }
        this.changeCount -= this.extraCount;
    }

    abstract void outputInsert(Change var1);

    abstract void outputDelete(Change var1);

    abstract void outputReplace(Change var1);

    abstract void outputMove(Change var1);

    abstract void outputMoveDelete(Change var1);

    abstract void outputMoveInsert(Change var1);

    class Change {
        private int number;
        private int olds;
        private int olde;
        private int news;
        private int newe;
        private int code;
        private int temp;
        private int temp2;
        private Change next;

        public Change(int code, int olds, int olde, int news, int newe, int number) {
            this.code = code;
            this.olds = olds;
            this.olde = olde;
            this.news = news;
            this.newe = newe;
            this.number = number;
        }

        public final int getCode() {
            return this.code;
        }

        public final int getOlds() {
            return this.olds;
        }

        public final int getOlde() {
            return this.olde;
        }

        public final int getNews() {
            return this.news;
        }

        public final int getNewe() {
            return this.newe;
        }

        public final int getNumber() {
            return this.number;
        }

        public final int getTemp() {
            return this.temp;
        }

        public final int getTemp2() {
            return this.temp2;
        }

        public final Change getNext() {
            return this.next;
        }

        public final void setCode(int code) {
            this.code = code;
        }

        public final void setOlds(int olds) {
            this.olds = olds;
        }

        public final void setOlde(int olde) {
            this.olde = olde;
        }

        public final void setNews(int news) {
            this.news = news;
        }

        public final void setNewe(int newe) {
            this.newe = newe;
        }

        public final void setNumber(int number) {
            this.number = number;
        }

        public final void setTemp(int temp) {
            this.temp = temp;
        }

        public final void setTemp2(int temp2) {
            this.temp2 = temp2;
        }

        public final void setNext(Change next) {
            this.next = next;
        }
    }

    public static interface ILine {
        public int hashCode();

        public boolean equals(Object var1);

        public int size();

        public int getStartLine();

        public int getStartColumn();

        public int getEndLine();

        public int getEndColumn();
    }
}

