/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternSymbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryRegistry {
    private Map<String, IPatternRepository> _repositories = new HashMap<String, IPatternRepository>();

    public void clear() {
        this._repositories.clear();
    }

    public IPattern getPattern(IPatternSymbol symbol_p) {
        IPattern result = null;
        IPatternRepository repository = this.getRepository(symbol_p.getRepositoryId());
        if (repository != null) {
            result = repository.getPattern(symbol_p);
        }
        return result;
    }

    public List<IPattern> getPatterns() {
        ArrayList<? extends IPattern> result = new ArrayList<IPattern>();
        for (IPatternRepository repository : this.getRepositories()) {
            result.addAll(repository.getPatterns());
        }
        return Collections.unmodifiableList(result);
    }

    public Collection<IPatternRepository> getRepositories() {
        return Collections.unmodifiableCollection(this._repositories.values());
    }

    public IPatternRepository getRepository(String id_p) {
        return this._repositories.get(id_p);
    }

    public void register(IPatternRepository repository_p) {
        this._repositories.put(repository_p.getId(), repository_p);
    }

    public void unregister(IPatternRepository repository_p) {
        this._repositories.remove(repository_p.getId());
    }
}

