/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.internal.context;

import java.util.List;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.diffmerge.internal.context.Activator;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;

public final class CompareControls {
    private CompareControls() {
    }

    public static boolean areEqual(VControl left, EObject leftDomainModel, VControl right, EObject rightDomainModel) {
        return CompareControls.areEqual(left.getDomainModelReference(), leftDomainModel, right.getDomainModelReference(), rightDomainModel);
    }

    public static boolean areEqual(VDomainModelReference left, EObject leftDomainModel, VDomainModelReference right, EObject rightDomainModel) {
        IObservableValue rightObservableValue;
        IObservableValue leftObservableValue;
        try {
            leftObservableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(left, leftDomainModel);
            rightObservableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(right, rightDomainModel);
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        EObject leftEObject = (EObject)((IObserving)leftObservableValue).getObserved();
        EStructuralFeature leftStructuralFeature = (EStructuralFeature)leftObservableValue.getValueType();
        EObject rightEObject = (EObject)((IObserving)rightObservableValue).getObserved();
        EStructuralFeature rightStructuralFeature = (EStructuralFeature)rightObservableValue.getValueType();
        leftObservableValue.dispose();
        rightObservableValue.dispose();
        Object leftValue = leftEObject.eGet(leftStructuralFeature, true);
        Object rightValue = rightEObject.eGet(rightStructuralFeature, true);
        return CompareControls.areValuesEqual(leftValue, leftStructuralFeature, rightValue, rightStructuralFeature);
    }

    public static boolean areValuesEqual(Object leftValue, EStructuralFeature leftStructuralFeature, Object rightValue, EStructuralFeature rightStructuralFeature) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        if (leftValue.equals(rightValue)) {
            return true;
        }
        if (CompareControls.isSingleReferences(leftStructuralFeature) && CompareControls.isSingleReferences(rightStructuralFeature)) {
            return EcoreUtil.equals((EObject)((EObject)EObject.class.cast(leftValue)), (EObject)((EObject)EObject.class.cast(rightValue)));
        }
        if (CompareControls.isMultiReference(leftStructuralFeature) && CompareControls.isMultiReference(rightStructuralFeature)) {
            return EcoreUtil.equals((List)((List)leftValue), (List)((List)rightValue));
        }
        return false;
    }

    private static boolean isMultiReference(EStructuralFeature leftStructuralFeature) {
        return EcorePackage.eINSTANCE.getEReference().isInstance((Object)leftStructuralFeature) && leftStructuralFeature.isMany();
    }

    private static boolean isSingleReferences(EStructuralFeature leftStructuralFeature) {
        return EcorePackage.eINSTANCE.getEReference().isInstance((Object)leftStructuralFeature) && !leftStructuralFeature.isMany();
    }
}

