/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.property;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProjectWrapper;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.emfstore.internal.client.accesscontrol.AccessControlHelper;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;

public final class EMFStoreIsServerAdminTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        InternalRepository repository = null;
        if (receiver instanceof EMFStoreProjectWrapper) {
            EMFStoreProjectWrapper wrapper = (EMFStoreProjectWrapper)receiver;
            repository = (InternalRepository)wrapper.getRepository();
        } else if (receiver instanceof InternalRepository) {
            repository = (InternalRepository)receiver;
        }
        if (repository == null) {
            return false;
        }
        ServerInfo serverInfo = (ServerInfo)((ESServerImpl)EMFStoreProvider.INSTANCE.getServerInfo(repository)).toInternalAPI();
        Usersession usersession = serverInfo.getLastUsersession();
        boolean isAdmin = false;
        if (usersession != null && usersession.getACUser() != null) {
            AccessControlHelper accessControlHelper = new AccessControlHelper(usersession);
            try {
                accessControlHelper.checkServerAdminAccess();
                isAdmin = true;
            }
            catch (AccessControlException accessControlException) {}
        }
        return Boolean.valueOf(isAdmin).equals(expectedValue);
    }
}

