/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.categorization.swt;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecp.view.spi.categorization.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.spi.swt.SWTRendererFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.GridDescriptionFactory;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridCell;
import org.eclipse.emf.ecp.view.spi.swt.layout.SWTGridDescription;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractSWTTabRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    public AbstractSWTTabRenderer() {
    }

    AbstractSWTTabRenderer(SWTRendererFactory factory) {
        super(factory);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        return GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        CTabFolder folder = new CTabFolder(parent, 1024);
        folder.setBackground(parent.getBackground());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        EList<VAbstractCategorization> categorizations = this.getCategorizations();
        for (VAbstractCategorization categorization : categorizations) {
            CTabItem item = new CTabItem(folder, 0);
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)categorization, IItemLabelProvider.class);
            String categorizationName = itemLabelProvider == null ? "Leaf Category" : itemLabelProvider.getText((Object)categorization);
            item.setText(categorizationName);
            AbstractSWTRenderer renderer = this.getSWTRendererFactory().getRenderer((VElement)categorization, this.getViewModelContext());
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            for (SWTGridCell gridCell : gridDescription.getGrid()) {
                Control render = renderer.render(gridCell, (Composite)folder);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(render);
                item.setControl(render);
            }
        }
        composedAdapterFactory.dispose();
        if (folder.getItemCount() > 0) {
            folder.setSelection(0);
        }
        return folder;
    }

    protected abstract EList<VAbstractCategorization> getCategorizations();
}

