/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.FileSubstitutionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class LargeFileSubstitutionHandler
extends FileSubstitutionHandler {
    private static final System.Logger LOG = System.getLogger(LargeFileSubstitutionHandler.class.getName());
    private static final String BACKUP_FILE_PREFIX = ".bkp";
    private static final String TEMP_FILE_PREFIX = ".tmp";
    private File _outputFile;

    public LargeFileSubstitutionHandler(File file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public Reader getReader() {
        try {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._inputFile), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            LOG.log(System.Logger.Level.INFO, () -> _strings.get("invalidFileLocation", new Object[]{this._inputFile.getAbsolutePath()}), (Throwable)e);
        }
        return this._reader;
    }

    @Override
    public Writer getWriter() {
        this._outputFile = new File(this._inputFile.getAbsolutePath() + TEMP_FILE_PREFIX);
        try {
            if (!this._outputFile.exists() && !this._outputFile.createNewFile()) {
                throw new IOException();
            }
            this._writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._outputFile), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.INFO, () -> _strings.get("failureTempFileCreation", new Object[]{this._outputFile.getAbsolutePath(), e}));
        }
        return this._writer;
    }

    @Override
    public void finish() {
        super.finish();
        String inputFileName = this._inputFile.getName();
        File inputBackUpfile = new File(this._inputFile.getAbsolutePath() + BACKUP_FILE_PREFIX);
        if (this._inputFile.renameTo(inputBackUpfile)) {
            if (this._outputFile.renameTo(new File(this._inputFile.getAbsolutePath()))) {
                if (!inputBackUpfile.delete()) {
                    LOG.log(System.Logger.Level.INFO, () -> _strings.get("failureInBackUpFileDeletion", new Object[]{inputBackUpfile.getAbsolutePath()}));
                }
            } else {
                LOG.log(System.Logger.Level.INFO, _strings.get("failureInFileRename", new Object[]{this._outputFile.getAbsolutePath(), inputFileName}));
            }
        } else {
            LOG.log(System.Logger.Level.WARNING, () -> _strings.get("failureInFileRename", new Object[]{this._inputFile.getAbsolutePath(), inputBackUpfile.getName()}));
        }
    }
}

