/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.i18n.MessageService;

final class ClobUtf8Writer
extends Writer {
    private TemporaryClob control;
    private long pos;
    private boolean closed;

    ClobUtf8Writer(TemporaryClob temporaryClob, long l) {
        this.control = temporaryClob;
        this.pos = l;
        this.closed = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            long l = this.control.insertString(String.copyValueOf(cArray, n, n2), this.pos);
            if (l > 0L) {
                this.pos += l;
            }
        }
        catch (SQLException sQLException) {
            throw Util.newIOException(sQLException);
        }
    }
}

