/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt;
import com.sun.corba.ee.spi.legacy.interceptor.UnknownType;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.iiop.security.CSIV2TaggedComponentInfo;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.security.SecureRandom;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.security.common.SharedSecureRandom;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.ORB;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

@Service
@Singleton
public class IIOPSSLUtilImpl
implements IIOPSSLUtil {
    private static final Logger LOG = LogDomains.getLogger(IIOPSSLUtilImpl.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    @Inject
    private SSLUtils sslUtils;
    private GlassFishORBHelper orbHelper;
    private Object appClientSSL;

    public Object getAppClientSSL() {
        return this.appClientSSL;
    }

    public void setAppClientSSL(Object ssl) {
        this.appClientSSL = ssl;
    }

    public KeyManager[] getKeyManagers(String alias) {
        try {
            if (alias != null && !this.sslUtils.isTokenKeyAlias(alias)) {
                LOG.log(Level.WARNING, "IIOP1004: Key alias {0} not found in keystore. Returning no key managers, SSL will not be supported.", alias);
                return new KeyManager[0];
            }
            KeyManager[] mgrs = this.sslUtils.getKeyManagers();
            if (alias != null && mgrs != null && mgrs.length > 0) {
                KeyManager[] newMgrs = new KeyManager[mgrs.length];
                for (int i = 0; i < mgrs.length; ++i) {
                    LOG.log(Level.FINE, "Setting J2EEKeyManager for alias {0}", alias);
                    newMgrs[i] = new J2EEKeyManager((X509KeyManager)mgrs[i], alias);
                }
                mgrs = newMgrs;
            }
            return mgrs;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TrustManager[] getTrustManagers() {
        try {
            return this.sslUtils.getTrustManagers();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SecureRandom getInitializedSecureRandom() {
        return SharedSecureRandom.SECURE_RANDOM;
    }

    public Object getSSLPortsAsSocketInfo(Object ior) {
        SecurityMechanismSelector selector = Lookups.getSecurityMechanismSelector();
        return selector.getSSLSocketInfo(ior);
    }

    public TaggedComponent createSSLTaggedComponent(IORInfo iorInfo, Object sInfos) {
        List socketInfos = (List)sInfos;
        this.orbHelper = Lookups.getGlassFishORBHelper();
        TaggedComponent result = null;
        ORB orb = this.orbHelper.getORB();
        int sslMutualAuthPort = -1;
        try {
            if (iorInfo instanceof IORInfoExt) {
                sslMutualAuthPort = ((IORInfoExt)iorInfo).getServerPort("SSL_MUTUALAUTH");
            }
        }
        catch (UnknownType ute) {
            LOG.log(Level.FINE, "UnknownType exception", ute);
        }
        LOG.log(Level.FINE, "sslMutualAuthPort: {0}", sslMutualAuthPort);
        CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb, sslMutualAuthPort);
        EjbDescriptor desc = ctc.getEjbDescriptor(iorInfo);
        if (desc != null) {
            result = ctc.createSecurityTaggedComponent(socketInfos, desc);
        }
        return result;
    }
}

