/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class RowCountNode
extends SingleChildResultSetNode {
    private ValueNode offset;
    private ValueNode fetchFirst;
    private boolean hasJDBClimitClause;

    RowCountNode(ResultSetNode resultSetNode, ResultColumnList resultColumnList, ValueNode valueNode, ValueNode valueNode2, boolean bl, ContextManager contextManager) throws StandardException {
        super(resultSetNode, null, contextManager);
        this.setResultColumns(resultColumnList);
        this.offset = valueNode;
        this.fetchFirst = valueNode2;
        this.hasJDBClimitClause = bl;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        boolean bl = false;
        boolean bl2 = false;
        if (this.offset != null) {
            this.generateExprFun(activationClassBuilder, methodBuilder, this.offset);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        if (this.fetchFirst != null) {
            this.generateExprFun(activationClassBuilder, methodBuilder, this.fetchFirst);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        methodBuilder.push(this.hasJDBClimitClause);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.callMethod((short)185, null, "getRowCountResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 8);
    }

    private void generateExprFun(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, ValueNode valueNode) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newExprFun();
        valueNode.generateExpression(expressionClassBuilder, methodBuilder2);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    @Override
    public String toString() {
        return "";
    }
}

