/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.cdi.types;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AnnotatedMethodWrapper<T>
implements AnnotatedMethod<T> {
    private final AnnotatedMethod<T> wrapped;
    private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

    public AnnotatedMethodWrapper(AnnotatedMethod<T> wrapped, Set<Annotation> additionalAnnotations, Predicate<Class> annotationBlacklist) {
        this.wrapped = wrapped;
        this.annotations.addAll(wrapped.getAnnotations().stream().filter(a -> !annotationBlacklist.test(a.annotationType())).collect(Collectors.toList()));
        this.annotations.addAll(additionalAnnotations);
    }

    public Method getJavaMember() {
        return this.wrapped.getJavaMember();
    }

    public boolean isStatic() {
        return this.wrapped.isStatic();
    }

    public AnnotatedType<T> getDeclaringType() {
        return this.wrapped.getDeclaringType();
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return this.wrapped.getParameters();
    }

    public Type getBaseType() {
        return this.wrapped.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrapped.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }
}

