/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.ProcessingState;

class HttpRequestPacketImpl
extends HttpRequestPacket {
    private static final ThreadCache.CachedTypeIndex<HttpRequestPacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpRequestPacketImpl.class, (int)16);
    private final ProcessingState processingState = new ProcessingState();

    public static HttpRequestPacketImpl create() {
        HttpRequestPacketImpl httpRequestImpl = (HttpRequestPacketImpl)ThreadCache.takeFromCache(CACHE_IDX);
        if (httpRequestImpl != null) {
            return httpRequestImpl;
        }
        return new HttpRequestPacketImpl(){

            @Override
            public void recycle() {
                super.recycle();
                ThreadCache.putToCache(CACHE_IDX, (Object)this);
            }
        };
    }

    protected HttpRequestPacketImpl() {
        this.isExpectContent = true;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.processingState;
    }

    @Override
    protected void reset() {
        this.processingState.recycle();
        this.isExpectContent = true;
        super.reset();
    }

    @Override
    public void recycle() {
        if (this.isExpectContent()) {
            return;
        }
        this.reset();
    }
}

