/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.glassfish.admin.amx.util.ArrayConversion;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Object[] toArray(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            T elem = iter.next();
            list.add(elem);
        }
        Object[] result = new Object[list.size()];
        list.toArray(result);
        return ArrayConversion.specializeArray(result);
    }

    public static Class getUniformClass(Iterator<?> iter) {
        Object next;
        Class<?> theClass = null;
        if (iter.hasNext()) {
            next = iter.next();
            Class<?> clazz = theClass = next == null ? null : next.getClass();
        }
        while (iter.hasNext()) {
            next = iter.next();
            if (next == null || next.getClass() == theClass) continue;
            theClass = null;
            break;
        }
        return theClass;
    }

    public static <T> boolean isUniformClass(Iterator<?> iter, Class<T> theClass, boolean exactMatch) {
        boolean isUniform = true;
        while (iter.hasNext()) {
            Object next = iter.next();
            Class<?> nextClass = next == null ? null : next.getClass();
            if (nextClass == theClass || nextClass == null) continue;
            if (exactMatch) {
                isUniform = false;
                break;
            }
            if (theClass.isAssignableFrom(nextClass)) continue;
            isUniform = false;
            break;
        }
        return isUniform;
    }
}

