/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.util.Iterator;

public class InterestUpdateHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public InterestUpdateHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "InterestUpdateHandler");
        }
        if (pkt.getType() == 9) {
            this.handleInterestUpdate(cb, pkt);
        } else if (pkt.getType() == 10) {
            this.handleInterestUpdateReply(sender, pkt);
        } else {
            this.logger.log(16, "InterestUpdateHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    private void handleInterestUpdate(MessageBusCallback cb, GPacket pkt) {
        block11: {
            ClusterConsumerInfo cci = ClusterConsumerInfo.newInstance(pkt, this.c);
            int c = cci.getConsumerCount();
            int t = cci.getSubtype();
            if (DEBUG) {
                this.logger.log(8, "handleInterestUpdate: subtype= " + t + ", count=" + c);
            }
            try {
                Iterator itr = cci.getConsumerUIDs();
                switch (t) {
                    case 2: 
                    case 3: {
                        while (itr.hasNext()) {
                            ConsumerUID intid = (ConsumerUID)itr.next();
                            Consumer cons = Consumer.getConsumer(intid);
                            if (cons == null && cci.isCleanup()) {
                                cons = Consumer.newInstance(intid);
                            }
                            if (cons == null) continue;
                            if (DEBUG) {
                                this.logger.log(8, "Remove remote interest: " + String.valueOf(cons) + ", pending=" + String.valueOf(cci.getPendingMessages()) + ", cleanup=" + cci.isCleanup());
                            }
                            cb.interestRemoved(cons, cci.getPendingMessages(), cci.isCleanup());
                        }
                        break;
                    }
                    case 4: {
                        while (itr.hasNext()) {
                            ConsumerUID intid = (ConsumerUID)itr.next();
                            Consumer cons = Consumer.getConsumer(intid);
                            if (cons == null) continue;
                            cb.activeStateChanged(cons);
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block11;
                this.logger.logStack(8, "Exception processing packet ", e);
            }
        }
    }

    private void handleInterestUpdateReply(BrokerAddress sender, GPacket pkt) {
        this.logger.log(4, "MessageBus: Received G_INTEREST_UPDATE_REPLY from {0} : STATUS = {1}", (Object)sender, pkt.getProp("S"));
    }
}

