/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.pluggable;

import com.sun.enterprise.security.ssl.manager.UnifiedX509KeyManager;
import com.sun.enterprise.security.ssl.manager.UnifiedX509TrustManager;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecuritySupport {
    @LogMessagesResourceBundle
    private static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.server.pluggable.LogMessages";
    @LoggerInfo(subsystem="SECURITY - SSL", description="Security - SSL", publish=true)
    private static final String SEC_SSL_LOGGER = "jakarta.enterprise.system.security.ssl";
    @LogMessageInfo(message="The SSL certificate with alias {0} has expired: {1}", level="SEVERE", cause="Certificate expired.", action="Check the expiration date of the certicate.")
    private static final String SSL_CERT_EXPIRED = "NCLS-SECURITY-05054";
    private static final Logger LOG = Logger.getLogger("jakarta.enterprise.system.security.ssl", "com.sun.enterprise.server.pluggable.LogMessages");
    private final List<KeyStore> keyStores = new ArrayList<KeyStore>();
    private final List<KeyStore> trustStores = new ArrayList<KeyStore>();
    private final List<char[]> keyStorePasswords = new ArrayList<char[]>();
    private final List<String> tokenNames = new ArrayList<String>();
    private final Date initDate = new Date();
    @Inject
    private ProcessEnvironment processEnvironment;
    @Inject
    private MasterPassword masterPassword;

    @PostConstruct
    private void init() {
        char[] keyStorePass;
        String keyStoreFileName = System.getProperty(GlassFishVariable.KEYSTORE_FILE.getSystemPropertyName());
        String trustStoreFileName = System.getProperty(GlassFishVariable.TRUSTSTORE_FILE.getSystemPropertyName());
        char[] trustStorePass = keyStorePass = this.masterPassword.getMasterPassword();
        boolean isAcc = this.processEnvironment.getProcessType().equals((Object)ProcessEnvironment.ProcessType.ACC);
        if (keyStorePass == null || isAcc) {
            String trustStorePassOverride;
            String keyStorePassOverride = System.getProperty(GlassFishVariable.KEYSTORE_PASSWORD.getSystemPropertyName(), "changeit");
            if (keyStorePassOverride != null) {
                keyStorePass = keyStorePassOverride.toCharArray();
            }
            if ((trustStorePassOverride = System.getProperty(GlassFishVariable.TRUSTSTORE_PASSWORD.getSystemPropertyName(), "changeit")) != null) {
                trustStorePass = trustStorePassOverride.toCharArray();
            }
        }
        this.loadStores(null, null, keyStoreFileName, keyStorePass, System.getProperty(GlassFishVariable.KEYSTORE_TYPE.getSystemPropertyName(), "PKCS12"), trustStoreFileName, trustStorePass, System.getProperty(GlassFishVariable.TRUSTSTORE_TYPE.getSystemPropertyName(), "PKCS12"));
        Arrays.fill(keyStorePass, ' ');
        Arrays.fill(trustStorePass, ' ');
    }

    public KeyStore[] getKeyStores() {
        return this.keyStores.toArray(new KeyStore[this.keyStores.size()]);
    }

    public KeyStore[] getTrustStores() {
        return this.trustStores.toArray(new KeyStore[this.trustStores.size()]);
    }

    public KeyStore getKeyStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return this.keyStores.get(idx);
    }

    public KeyStore getTrustStore(String token) {
        int idx = this.getTokenIndex(token);
        if (idx < 0) {
            return null;
        }
        return this.trustStores.get(idx);
    }

    public KeyStore loadNullStore(String type, int index) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(null, this.keyStorePasswords.get(index));
        return keyStore;
    }

    public boolean verifyMasterPassword(char[] masterPass) {
        return Arrays.equals(masterPass, this.keyStorePasswords.get(0));
    }

    public KeyManager[] getKeyManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore[] kstores = this.getKeyStores();
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        for (int i = 0; i < kstores.length; ++i) {
            SecuritySupport.checkCertificateDates(kstores[i], this.initDate);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : algorithm);
            kmf.init(kstores[i], this.keyStorePasswords.get(i));
            KeyManager[] kmgrs = kmf.getKeyManagers();
            if (kmgrs == null) continue;
            keyManagers.addAll(Arrays.asList(kmgrs));
        }
        UnifiedX509KeyManager keyManager = new UnifiedX509KeyManager(keyManagers.toArray(new X509KeyManager[keyManagers.size()]), this.getTokenNames());
        return new KeyManager[]{keyManager};
    }

    public TrustManager[] getTrustManagers(String algorithm) throws IOException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore[] tstores = this.getTrustStores();
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        for (KeyStore tstore : tstores) {
            SecuritySupport.checkCertificateDates(tstore, this.initDate);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : algorithm);
            tmf.init(tstore);
            TrustManager[] tmgrs = tmf.getTrustManagers();
            if (tmgrs == null) continue;
            trustManagers.addAll(Arrays.asList(tmgrs));
        }
        TrustManager trustManager = trustManagers.size() == 1 ? (TrustManager)trustManagers.get(0) : new UnifiedX509TrustManager(trustManagers.toArray(new X509TrustManager[trustManagers.size()]));
        return new TrustManager[]{trustManager};
    }

    public PrivateKey getPrivateKeyForAlias(String alias, int keystoreIndex) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = this.keyStores.get(keystoreIndex).getKey(alias, this.keyStorePasswords.get(keystoreIndex));
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        return null;
    }

    public String[] getTokenNames() {
        return this.tokenNames.toArray(new String[this.tokenNames.size()]);
    }

    private int getTokenIndex(String token) {
        int idx = -1;
        if (token != null && (idx = this.tokenNames.indexOf(token)) < 0) {
            LOG.log(Level.FINEST, "Token {0} not found", token);
        }
        return idx;
    }

    private void loadStores(String tokenName, Provider provider, String keyStoreFilePath, char[] keyStorePass, String keyStoreType, String trustStoreFilePath, char[] trustStorePass, String trustStoreType) {
        try {
            KeyStore keyStore = SecuritySupport.getKeyStore(keyStoreType, provider, keyStoreFilePath, keyStorePass);
            KeyStore trustStore = SecuritySupport.getKeyStore(trustStoreType, provider, trustStoreFilePath, trustStorePass);
            this.keyStores.add(keyStore);
            this.trustStores.add(trustStore);
            this.keyStorePasswords.add(Arrays.copyOf(keyStorePass, keyStorePass.length));
            this.tokenNames.add(tokenName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static KeyStore getKeyStore(String keyStoreType, Provider provider, String keyStoreFilePath, char[] keyStorePass) throws Exception {
        File keyStoreFile;
        File file = keyStoreFile = keyStoreFilePath == null ? null : new File(keyStoreFilePath);
        if (keyStoreFile == null) {
            return SecuritySupport.createEmptyKeyStore(keyStoreType, provider, keyStorePass);
        }
        if (!keyStoreFile.exists()) {
            LOG.log(Level.WARNING, "Keystore file does not exist: {0}. Generating default empty keystore.", keyStoreFile);
            return SecuritySupport.createEmptyKeyStore(keyStoreType, provider, keyStorePass);
        }
        return SecuritySupport.loadKS(keyStoreType, provider, keyStoreFile, keyStorePass);
    }

    private static KeyStore loadKS(String keyStoreType, Provider provider, File keyStoreFile, char[] keyStorePass) throws Exception {
        KeyStore keyStore = SecuritySupport.createKeyStore(keyStoreType, provider);
        try (FileInputStream istream = new FileInputStream(keyStoreFile);
             BufferedInputStream bstream = new BufferedInputStream(istream);){
            LOG.log(Level.FINE, "Loading keystoreFile = {0}", keyStoreFile);
            keyStore.load(bstream, keyStorePass);
        }
        return keyStore;
    }

    private static KeyStore createEmptyKeyStore(String keyStoreType, Provider provider, char[] keyStorePass) throws IOException, GeneralSecurityException {
        KeyStore keyStore = SecuritySupport.createKeyStore(keyStoreType, provider);
        keyStore.load(null, keyStorePass);
        return keyStore;
    }

    private static KeyStore createKeyStore(String keyStoreType, Provider provider) throws KeyStoreException {
        if (provider == null) {
            return KeyStore.getInstance(keyStoreType);
        }
        return KeyStore.getInstance(keyStoreType, provider);
    }

    private static void checkCertificateDates(KeyStore store, Date date) throws KeyStoreException {
        Enumeration<String> aliases = store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = store.getCertificate(alias);
            if (!(cert instanceof X509Certificate) || !((X509Certificate)cert).getNotAfter().before(date)) continue;
            LOG.log(Level.SEVERE, SSL_CERT_EXPIRED, new Object[]{alias, cert});
        }
    }
}

