/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.ServletRequest;
import java.util.ResourceBundle;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.connector.SessionTracker;

public class RequestFacadeHelper {
    private Request request;
    private Response response;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    public RequestFacadeHelper(Request request) {
        this.request = request;
        this.response = (Response)request.getResponse();
    }

    public static RequestFacadeHelper getInstance(ServletRequest srvRequest) {
        RequestFacadeHelper reqFacHelper = (RequestFacadeHelper)srvRequest.getAttribute("org.glassfish.web.RequestFacadeHelper");
        return reqFacHelper;
    }

    int incrementDispatchDepth() {
        this.validateRequest();
        return this.request.incrementDispatchDepth();
    }

    int decrementDispatchDepth() {
        this.validateRequest();
        return this.request.decrementDispatchDepth();
    }

    boolean isMaxDispatchDepthReached() {
        this.validateRequest();
        return this.request.isMaxDispatchDepthReached();
    }

    void track(Session localSession) {
        this.validateRequest();
        SessionTracker sessionTracker = (SessionTracker)this.request.getNote("com.sun.enterprise.http.sessionTracker");
        if (sessionTracker != null) {
            sessionTracker.track(localSession);
        }
    }

    String getContextPath(boolean maskDefaultContextMapping) {
        this.validateRequest();
        return this.request.getContextPath(maskDefaultContextMapping);
    }

    void disableAsyncSupport() {
        this.validateRequest();
        this.request.disableAsyncSupport();
    }

    boolean isResponseError() {
        this.validateResponse();
        return this.response.isError();
    }

    String getResponseMessage() {
        this.validateResponse();
        return this.response.getMessage();
    }

    int getResponseContentCount() {
        this.validateResponse();
        return this.response.getContentCount();
    }

    void resetResponse() {
        this.validateResponse();
        this.response.setSuspended(false);
        this.response.setAppCommitted(false);
    }

    public void clear() {
        this.request = null;
        this.response = null;
    }

    private void validateRequest() {
        if (this.request == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00125"));
        }
    }

    private void validateResponse() {
        if (this.response == null) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00126"));
        }
    }
}

