/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.validate;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.mvc.MvcContext;
import jakarta.mvc.binding.MvcBinding;
import jakarta.mvc.binding.ValidationError;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableValidator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.binding.BindingResultImpl;
import org.eclipse.krazo.binding.ConstraintViolationTranslator;
import org.eclipse.krazo.binding.ValidationErrorImpl;
import org.eclipse.krazo.binding.validate.ConstraintViolationMetadata;
import org.eclipse.krazo.binding.validate.ConstraintViolations;
import org.eclipse.krazo.binding.validate.ValidationInterceptorBinding;
import org.eclipse.krazo.cdi.Internal;

@Interceptor
@ValidationInterceptorBinding
@Priority(value=1000)
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = -5804986456381504613L;
    private static final Logger log = Logger.getLogger(ValidationInterceptor.class.getName());
    @Inject
    @Internal
    private ValidatorFactory validatorFactory;
    @Inject
    private ConstraintViolationTranslator violationTranslator;
    @Inject
    private MvcContext mvcContext;
    @Inject
    private BindingResultImpl bindingResult;

    @AroundInvoke
    public Object validateMethodInvocation(InvocationContext ctx) throws Exception {
        Object resource = ctx.getTarget();
        Method method = ctx.getMethod();
        log.log(Level.FINE, "Starting validation for controller method: {0}#{1}", new Object[]{resource.getClass().getName(), method.getName()});
        Validator validator = this.validatorFactory.getValidator();
        ExecutableValidator executableValidator = validator.forExecutables();
        this.processViolations(ctx, validator.validate(resource, new Class[0]));
        this.processViolations(ctx, executableValidator.validateParameters(resource, method, ctx.getParameters(), new Class[0]));
        Object result = ctx.proceed();
        this.processViolations(ctx, executableValidator.validateReturnValue(resource, method, result, new Class[0]));
        return result;
    }

    private void processViolations(InvocationContext ctx, Set<ConstraintViolation<Object>> violations) {
        if (violations.isEmpty()) {
            return;
        }
        log.log(Level.FINE, "Validation found {0} constraint violations...", violations.size());
        LinkedHashSet<ValidationError> validationErrors = new LinkedHashSet<ValidationError>();
        for (ConstraintViolation<Object> violation : violations) {
            boolean hasBindingError;
            ConstraintViolationMetadata metadata = ConstraintViolations.getMetadata(violation);
            if (!metadata.hasAnnotation(MvcBinding.class)) continue;
            String paramName = metadata.getParamName().orElse(null);
            if (paramName == null) {
                log.log(Level.WARNING, "Cannot resolve paramName for violation: {0}", violation);
            }
            if (hasBindingError = paramName != null && !paramName.isEmpty() && this.bindingResult.getErrors(paramName).size() > 0) continue;
            String message = this.violationTranslator.translate(violation, this.mvcContext.getLocale());
            validationErrors.add(new ValidationErrorImpl(violation, paramName, message));
        }
        if (!validationErrors.isEmpty()) {
            log.log(Level.FINE, "Adding {0} validation errors to binding result", validationErrors.size());
            this.bindingResult.addValidationErrors(validationErrors);
        }
    }
}

