/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class AppservAccessController {
    private static final boolean SECURITY_MGR_DISABLED = System.getSecurityManager() == null;

    private AppservAccessController() {
    }

    public static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (SECURITY_MGR_DISABLED) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    public static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (SECURITY_MGR_DISABLED) {
            try {
                return action.run();
            }
            catch (Exception e) {
                throw new PrivilegedActionException(e);
            }
        }
        return AccessController.doPrivileged(action);
    }
}

