/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class DeclarationStatement
extends Statement {
    int mod;
    Expression type;
    Statement[] args;

    public DeclarationStatement(long where, int mod, Expression type, Statement[] args) {
        super(107, where);
        this.mod = mod;
        this.type = type;
        this.args = args;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        env.error(this.where, "invalid.decl");
        return this.checkBlockStatement(env, ctx, vset, exp);
    }

    @Override
    Vset checkBlockStatement(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        if (this.labels != null) {
            env.error(this.where, "declaration.with.label", this.labels[0]);
        }
        vset = this.reach(env, vset);
        Type t = this.type.toType(env, ctx);
        for (int i = 0; i < this.args.length; ++i) {
            vset = this.args[i].checkDeclaration(env, ctx, vset, this.mod, t, exp);
        }
        return vset;
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        int n = 0;
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = this.args[i].inline(env, ctx);
            if (this.args[i] == null) continue;
            ++n;
        }
        return n == 0 ? null : this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        DeclarationStatement s = (DeclarationStatement)this.clone();
        if (this.type != null) {
            s.type = this.type.copyInline(ctx);
        }
        s.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            s.args[i] = this.args[i].copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 1;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            cost += this.args[i].costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i].code(env, ctx, asm);
        }
    }

    @Override
    public void print(PrintStream out, int indent) {
        out.print("declare ");
        super.print(out, indent);
        this.type.print(out);
        out.print(" ");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            if (this.args[i] != null) {
                this.args[i].print(out);
                continue;
            }
            out.print("<empty>");
        }
        out.print(";");
    }
}

