/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.AppTenant;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service(name="_mt-undeploy")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
public class MTUndeployCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(primary=true)
    public String name;
    @Inject
    CommandRunner<?> commandRunner;
    @Inject
    Applications applications;
    private Application app;
    private List<AppTenant> appTenants = null;

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        this.app = this.applications.getApplication(this.name);
        if (this.app != null) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.app), "read"));
            if (this.app.getAppTenants() != null) {
                this.appTenants = this.app.getAppTenants().getAppTenant();
                for (AppTenant appTenant : this.appTenants) {
                    accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)appTenant), "delete"));
                }
            }
        }
        return accessChecks;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.unprovisionAppFromTenants(this.name, report, context.getSubject());
        CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", report, context.getSubject());
        ParameterMap parameters = new ParameterMap();
        parameters.set((Object)"DEFAULT", (Object)this.name);
        parameters.set((Object)"target", (Object)"domain");
        inv.parameters(parameters).execute();
    }

    private void unprovisionAppFromTenants(String appName, ActionReport report, Subject subject) {
        if (this.app == null || this.appTenants == null) {
            return;
        }
        for (AppTenant tenant : this.appTenants) {
            ActionReport subReport = report.addSubActionsReport();
            CommandInvocation inv = this.commandRunner.getCommandInvocation("_mt-unprovision", subReport, subject);
            ParameterMap parameters = new ParameterMap();
            parameters.add((Object)"DEFAULT", (Object)appName);
            parameters.add((Object)"tenant", (Object)tenant.getTenant());
            inv.parameters(parameters).execute();
        }
    }
}

