/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.apache.catalina.ssi.ResponseIncludeWrapper;
import org.apache.catalina.ssi.SSIProcessor;
import org.apache.catalina.ssi.SSIServletExternalResolver;

public class SSIFilter
implements Filter {
    protected FilterConfig config = null;
    protected int debug = 0;
    protected Long expires = null;
    protected boolean isVirtualWebappRelative = false;
    protected Pattern contentTypeRegEx = null;
    protected Pattern shtmlRegEx = Pattern.compile("text/x-server-parsed-html(;.*)?");

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        if (config.getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(config.getInitParameter("debug"));
        }
        this.contentTypeRegEx = config.getInitParameter("contentType") != null ? Pattern.compile(config.getInitParameter("contentType")) : this.shtmlRegEx;
        this.isVirtualWebappRelative = Boolean.parseBoolean(config.getInitParameter("isVirtualWebappRelative"));
        if (config.getInitParameter("expires") != null) {
            this.expires = Long.valueOf(config.getInitParameter("expires"));
        }
        if (this.debug > 0) {
            config.getServletContext().log("SSIFilter.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        req.setAttribute("org.apache.catalina.ssi.SSIServlet", (Object)"true");
        ByteArrayServletOutputStream basos = new ByteArrayServletOutputStream();
        ResponseIncludeWrapper responseIncludeWrapper = new ResponseIncludeWrapper(this.config.getServletContext(), req, res, basos);
        chain.doFilter((ServletRequest)req, (ServletResponse)responseIncludeWrapper);
        responseIncludeWrapper.flushOutputStreamOrWriter();
        byte[] bytes = basos.toByteArray();
        String contentType = responseIncludeWrapper.getContentType();
        if (this.contentTypeRegEx.matcher(contentType).matches()) {
            String encoding = res.getCharacterEncoding();
            SSIServletExternalResolver ssiExternalResolver = new SSIServletExternalResolver(this.config.getServletContext(), req, res, this.isVirtualWebappRelative, this.debug, encoding);
            SSIProcessor ssiProcessor = new SSIProcessor(ssiExternalResolver, this.debug);
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), encoding);
            ByteArrayOutputStream ssiout = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)ssiout, encoding));
            long lastModified = ssiProcessor.process(reader, responseIncludeWrapper.getLastModified(), writer);
            writer.flush();
            bytes = ssiout.toByteArray();
            if (this.expires != null) {
                res.setDateHeader("expires", new Date().getTime() + this.expires * 1000L);
            }
            if (lastModified > 0L) {
                res.setDateHeader("last-modified", lastModified);
            }
            res.setContentLength(bytes.length);
            Matcher shtmlMatcher = this.shtmlRegEx.matcher(responseIncludeWrapper.getContentType());
            if (shtmlMatcher.matches()) {
                String enc = shtmlMatcher.group(1);
                res.setContentType("text/html" + (enc != null ? enc : ""));
            }
        }
        ServletOutputStream out = null;
        try {
            out = res.getOutputStream();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (out == null) {
            res.getWriter().write(new String(bytes, Charset.defaultCharset()));
        } else {
            out.write(bytes);
        }
    }

    public void destroy() {
    }
}

