/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.EmbeddedProviderContainerContractInfo;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.JPApplicationContainer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ServerProviderContainerContractInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPApplicationContainer>
implements PostConstruct,
EventListener {
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, (String)"jakarta.org.glassfish.persistence.jpadeployer");
    private static final String ENTITY_MANAGER_FACTORY_KEY = EntityManagerFactory.class.toString();
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    private volatile StartupContext startupContext;
    @Inject
    private Events events;
    @Inject
    private ApplicationRegistry applicationRegistry;

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public boolean prepare(DeploymentContext deploymentContext) {
        boolean prepared = super.prepare(deploymentContext);
        if (prepared && this.isEntityManagerFactoryCreationRequired(deploymentContext)) {
            this.createEntityManagerFactories(deploymentContext);
        }
        return prepared;
    }

    public JPApplicationContainer load(JPAContainer container, DeploymentContext context) {
        return new JPApplicationContainer();
    }

    protected void cleanArtifacts(DeploymentContext deploymentContext) throws DeploymentException {
        OpsParams params = deploymentContext.getCommandParameters(OpsParams.class);
        if (params.origin.isUndeploy() && this.isDas()) {
            Application application = (Application)this.applicationRegistry.get(params.name()).getMetaData(Application.class);
            boolean hasScopedResource = this.hasScopedResource(application);
            if (hasScopedResource) {
                this.connectorRuntime.registerDataSourceDefinitions(application);
            }
            Java2DBProcessorHelper java2DBProcessor = new Java2DBProcessorHelper(deploymentContext);
            java2DBProcessor.init();
            java2DBProcessor.createOrDropTablesInDB(false, "JPA");
            if (hasScopedResource) {
                this.connectorRuntime.unRegisterDataSourceDefinitions(application);
            }
        }
    }

    public void event(EventListener.Event<?> event) {
        logger.log(Level.FINE, () -> "JpaDeployer.event():" + event.name());
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            DeployCommandParameters deployCommandParameters = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
            logger.log(Level.FINE, () -> "JpaDeployer.event(): Handling APPLICATION_PREPARED origin is:" + String.valueOf(deployCommandParameters.origin));
            if (!deployCommandParameters.origin.isCreateAppRef() || JPADeployer.isTargetDas(deployCommandParameters)) {
                for (DeploymentContext deploymentContext : context.getModuleDeploymentContexts().values()) {
                    this.iterateInitializedPUsAtApplicationPrepare(deploymentContext);
                }
                this.iterateInitializedPUsAtApplicationPrepare((DeploymentContext)context);
            }
        } else if (event.is(Deployment.APPLICATION_DISABLED)) {
            logger.fine("JpaDeployer.event(): APPLICATION_DISABLED");
            this.closeEntityManagerFactories((ApplicationInfo)event.hook());
        }
    }

    private boolean isEntityManagerFactoryCreationRequired(DeploymentContext context) {
        boolean createEntityManagerFactories = false;
        DeployCommandParameters deployCommandParameters = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        boolean deploy = deployCommandParameters.origin.isDeploy();
        boolean enabled = deployCommandParameters.enabled;
        boolean isDas = this.isDas();
        logger.log(Level.FINER, () -> "isEMFCreationRequired(): deploy: " + deploy + " enabled: " + enabled + " isDas: " + isDas);
        if (isDas) {
            if (deploy) {
                createEntityManagerFactories = true;
            } else {
                boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
                logger.log(Level.FINER, () -> "isEMFCreationRequired(): isTargetDas: " + isTargetDas);
                if (enabled && isTargetDas) {
                    createEntityManagerFactories = true;
                }
            }
        } else if (enabled) {
            createEntityManagerFactories = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isEMFCreationRequired(): returning createEMFs:" + createEntityManagerFactories);
        }
        return createEntityManagerFactories;
    }

    private static String getUniquePersistenceUnitIdentifier(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        return persistenceUnitDescriptor.getAbsolutePuRoot() + persistenceUnitDescriptor.getName();
    }

    private static boolean isTargetDas(DeployCommandParameters deployCommandParameters) {
        return "server".equals(deployCommandParameters.target);
    }

    private boolean isDas() {
        return this.serverEnvironment.isDas() || this.serverEnvironment.isEmbedded();
    }

    private void createEntityManagerFactories(DeploymentContext deploymentContext) {
        Application application = (Application)deploymentContext.getModuleMetaData(Application.class);
        if (this.hasScopedResource(application)) {
            this.connectorRuntime.registerDataSourceDefinitions(application);
        }
        for (PersistenceUnitDescriptor persistenceUnitDescriptor : JPADeployer.getPersistenceUnitDescriptors(deploymentContext)) {
            this.loadPersistenceUnit(persistenceUnitDescriptor, deploymentContext);
        }
    }

    private boolean hasScopedResource(Application application) {
        for (BundleDescriptor bundleDescriptor : application.getBundleDescriptors()) {
            HashSet<PersistenceUnitDescriptor> allPersistenceUnitDescriptors = new HashSet<PersistenceUnitDescriptor>();
            allPersistenceUnitDescriptors.addAll(JPADeployer.getPersistenceUnitDescriptors(bundleDescriptor));
            allPersistenceUnitDescriptors.addAll(bundleDescriptor.findReferencedPUs());
            for (PersistenceUnitDescriptor persistenceUnitDescriptor : allPersistenceUnitDescriptors) {
                if (!this.hasScopedResource(persistenceUnitDescriptor)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasScopedResource(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        SimpleJndiName jtaDataSource = persistenceUnitDescriptor.getJtaDataSource();
        return jtaDataSource != null && jtaDataSource.hasJavaPrefix();
    }

    private static List<PersistenceUnitDescriptor> getPersistenceUnitDescriptors(DeploymentContext context) {
        BundleDescriptor bundle = DOLUtils.getCurrentBundleForContext((DeploymentContext)context);
        if (bundle == null) {
            return Collections.emptyList();
        }
        return JPADeployer.getPersistenceUnitDescriptors(bundle);
    }

    private static List<PersistenceUnitDescriptor> getPersistenceUnitDescriptors(BundleDescriptor bundle) {
        ArrayList<PersistenceUnitDescriptor> persistenceUnitDescriptors = new ArrayList<PersistenceUnitDescriptor>();
        for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : bundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
            persistenceUnitDescriptors.addAll(persistenceUnitsDescriptor.getPersistenceUnitDescriptors());
        }
        return persistenceUnitDescriptors;
    }

    private void loadPersistenceUnit(PersistenceUnitDescriptor persistenceUnitDescriptor, DeploymentContext deploymentContext) {
        boolean isDas = this.isDas();
        boolean weavingEnabled = Boolean.parseBoolean(this.startupContext.getArguments().getProperty("org.glassfish.persistence.embedded.weaving.enabled", "true"));
        ServerProviderContainerContractInfo providerContainerContractInfo = weavingEnabled ? new ServerProviderContainerContractInfo(deploymentContext, this.connectorRuntime, isDas) : new EmbeddedProviderContainerContractInfo(deploymentContext, this.connectorRuntime, isDas);
        try {
            ((ExtendedDeploymentContext)deploymentContext).prepareScratchDirs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        PersistenceUnitLoader persistenceUnitLoader = new PersistenceUnitLoader(persistenceUnitDescriptor, providerContainerContractInfo);
        deploymentContext.addTransientAppMetaData(JPADeployer.getUniquePersistenceUnitIdentifier(persistenceUnitDescriptor), (Object)persistenceUnitLoader);
    }

    private void iterateInitializedPUsAtApplicationPrepare(DeploymentContext context) {
        for (PersistenceUnitDescriptor descriptor : JPADeployer.getPersistenceUnitDescriptors(context)) {
            this.doPersistenceSchemaGeneration(descriptor, context);
        }
    }

    private void doPersistenceSchemaGeneration(PersistenceUnitDescriptor persistenceUnitDescriptor, DeploymentContext deploymentContext) {
        PersistenceUnitLoader persistenceUnitLoader = (PersistenceUnitLoader)deploymentContext.getTransientAppMetaData(JPADeployer.getUniquePersistenceUnitIdentifier(persistenceUnitDescriptor), PersistenceUnitLoader.class);
        if (persistenceUnitLoader == null) {
            return;
        }
        boolean saveEntityManagerFactory = true;
        DeployCommandParameters deployCommandParameters = (DeployCommandParameters)deploymentContext.getCommandParameters(DeployCommandParameters.class);
        if (this.isDas() && deployCommandParameters.origin.isDeploy()) {
            EntityManagerFactory entityManagerFactory = persistenceUnitLoader.getEntityManagerFactory();
            try {
                EntityManager entityManager = entityManagerFactory.createEntityManager();
                if (entityManager != null) {
                    entityManager.close();
                }
            }
            catch (PersistenceException e) {
                entityManagerFactory.close();
                throw new DeploymentException((Throwable)e);
            }
            persistenceUnitLoader.doJava2DB();
            boolean enabled = deployCommandParameters.enabled;
            boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
            logger.log(Level.FINER, () -> "iterateInitializedPUsAtApplicationPrepare(): enabled: " + enabled + " isTargetDas: " + isTargetDas);
            if (!isTargetDas || !enabled) {
                entityManagerFactory.close();
                saveEntityManagerFactory = false;
            }
        }
        if (saveEntityManagerFactory) {
            this.saveEntityManagerFactory(this.applicationRegistry.get(deployCommandParameters.name), persistenceUnitLoader.getEntityManagerFactory());
        }
    }

    public List<EntityManagerFactory> getEntityManagerFactories(ApplicationInfo applicationInfo) {
        List emfsCreatedForThisApp = (List)applicationInfo.getTransientAppMetaData(ENTITY_MANAGER_FACTORY_KEY, List.class);
        return emfsCreatedForThisApp != null ? Collections.unmodifiableList(emfsCreatedForThisApp) : List.of();
    }

    private void saveEntityManagerFactory(ApplicationInfo applicationInfo, EntityManagerFactory entityManagerFactory) {
        ArrayList<EntityManagerFactory> emfsCreatedForThisApp = (ArrayList<EntityManagerFactory>)applicationInfo.getTransientAppMetaData(ENTITY_MANAGER_FACTORY_KEY, List.class);
        if (emfsCreatedForThisApp == null) {
            emfsCreatedForThisApp = new ArrayList<EntityManagerFactory>();
            applicationInfo.addTransientAppMetaData(ENTITY_MANAGER_FACTORY_KEY, emfsCreatedForThisApp);
        }
        emfsCreatedForThisApp.add(entityManagerFactory);
    }

    private void closeEntityManagerFactories(ApplicationInfo appInfo) {
        List entityManagerFactoriesCreatedForThisApp = (List)appInfo.getTransientAppMetaData(ENTITY_MANAGER_FACTORY_KEY, List.class);
        if (entityManagerFactoriesCreatedForThisApp != null) {
            for (EntityManagerFactory entityManagerFactory : entityManagerFactoriesCreatedForThisApp) {
                entityManagerFactory.close();
            }
            entityManagerFactoriesCreatedForThisApp.clear();
        }
    }
}

