/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper.linkedlist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;

public class ExposedNodeLinkedList<E>
implements List<E> {
    private transient LinkedNode<E> header = new LinkedNode<Object>(null, null, null);
    private transient int size = 0;

    public ExposedNodeLinkedList() {
        this.header.next = this.header;
        this.header.previous = this.header;
    }

    @Override
    public <E> E[] toArray(E[] array) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList toArray");
    }

    @Override
    public E[] toArray() {
        throw new UnsupportedOperationException("ExposedNodeLinkedList toArray");
    }

    @Override
    public E set(int index, E value) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList set");
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList listIterator");
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException("ExposedNodeLinkedList listIterator");
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("ExposedNodeLinkedList iterator");
    }

    @Override
    public List<E> subList(int start, int end) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList subList");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList retainAll");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList removeAll");
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList containsAll");
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList addAll");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList addAll");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList remove");
    }

    @Override
    public boolean add(E object) {
        this.addLast(object);
        return true;
    }

    @Override
    public int lastIndexOf(Object object) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList lastIndexOf");
    }

    @Override
    public void add(int index, E object) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList add");
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList remove");
    }

    @Override
    public E get(int index) {
        throw new UnsupportedOperationException("ExposedNodeLinkedList get");
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.header.next.contents;
    }

    @Override
    public E getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.header.previous.contents;
    }

    @Override
    public E removeFirst() {
        if (this.size != 0) {
            Object first = this.header.next.contents;
            this.remove(this.header.next);
            return first;
        }
        return null;
    }

    @Override
    public E removeLast() {
        if (this.size != 0) {
            Object last = this.header.previous.contents;
            this.remove(this.header.previous);
            return last;
        }
        return null;
    }

    @Override
    public void addFirst(E o) {
        this.addAfter(o, this.header);
    }

    public LinkedNode<E> addFirstElement(E o) {
        return this.addAfter(o, this.header);
    }

    @Override
    public void addLast(E o) {
        this.addAfter(o, this.header.previous);
    }

    public LinkedNode<E> addLastElement(E o) {
        return this.addAfter(o, this.header.previous);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            LinkedNode n = this.header.next;
            while (n != this.header) {
                if (n.contents == null) {
                    return index;
                }
                ++index;
                n = n.next;
            }
        } else {
            LinkedNode n = this.header.next;
            while (n != this.header) {
                if (o.equals(n.contents)) {
                    return index;
                }
                ++index;
                n = n.next;
            }
        }
        return -1;
    }

    private LinkedNode<E> addAfter(E o, LinkedNode<E> n) {
        LinkedNode<E> newNode = new LinkedNode<E>(o, n.next, n);
        newNode.previous.next = newNode;
        newNode.next.previous = newNode;
        ++this.size;
        return newNode;
    }

    public void remove(LinkedNode<E> n) {
        if (n == this.header) {
            throw new NoSuchElementException();
        }
        if (n.previous == null || n.next == null) {
            return;
        }
        n.previous.next = n.next;
        n.next.previous = n.previous;
        n.previous = null;
        n.next = null;
        n.contents = null;
        --this.size;
    }

    public void moveFirst(LinkedNode<E> node) {
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        if (node.previous == null || node.next == null) {
            ++this.size;
        } else {
            node.previous.next = node.next;
            node.next.previous = node.previous;
        }
        node.next = this.header.next;
        node.previous = this.header;
        this.header.next = node;
        node.next.previous = node;
    }
}

