/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging.jul;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import org.eclipse.persistence.logging.jul.EclipseLinkLogRecord;

public class XMLLogFormatter
extends XMLFormatter {
    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        sb.append(date.getYear() + 1900);
        sb.append('-');
        this.a2(sb, date.getMonth() + 1);
        sb.append('-');
        this.a2(sb, date.getDate());
        sb.append('T');
        this.a2(sb, date.getHours());
        sb.append(':');
        this.a2(sb, date.getMinutes());
        sb.append(':');
        this.a2(sb, date.getSeconds());
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            sb.append(ch);
        }
    }

    @Override
    public String format(LogRecord record0) {
        StringBuffer sb;
        EclipseLinkLogRecord record;
        block18: {
            if (!(record0 instanceof EclipseLinkLogRecord)) {
                return super.format(record0);
            }
            record = (EclipseLinkLogRecord)record0;
            sb = new StringBuffer(500);
            sb.append("<record>\n");
            if (record.shouldPrintDate()) {
                sb.append("  <date>");
                this.appendISO8601(sb, record.getMillis());
                sb.append("</date>\n");
                sb.append("  <millis>");
                sb.append(record.getMillis());
                sb.append("</millis>\n");
            }
            sb.append("  <sequence>");
            sb.append(record.getSequenceNumber());
            sb.append("</sequence>\n");
            String name = record.getLoggerName();
            if (name != null) {
                sb.append("  <logger>");
                this.escape(sb, name);
                sb.append("</logger>\n");
            }
            sb.append("  <level>");
            this.escape(sb, record.getLevel().toString());
            sb.append("</level>\n");
            if (record.getSourceClassName() != null) {
                sb.append("  <class>");
                this.escape(sb, record.getSourceClassName());
                sb.append("</class>\n");
            }
            if (record.getSourceMethodName() != null) {
                sb.append("  <method>");
                this.escape(sb, record.getSourceMethodName());
                sb.append("</method>\n");
            }
            if (record.getSessionString() != null) {
                sb.append("  <session>");
                sb.append(record.getSessionString());
                sb.append("</session>\n");
            }
            if (record.getConnectionId() != null) {
                sb.append("  <connection>");
                sb.append(record.getConnectionId());
                sb.append("</connection>\n");
            }
            if (record.shouldPrintThread()) {
                sb.append("  <thread>");
                sb.append(record.getThreadID());
                sb.append("</thread>\n");
            }
            if (record.getMessage() != null) {
                String message = this.formatMessage(record);
                sb.append("  <message>");
                this.escape(sb, message);
                sb.append("</message>");
                sb.append("\n");
            }
            ResourceBundle bundle = record.getResourceBundle();
            try {
                if (bundle == null) break block18;
                bundle.getString(record.getMessage());
                sb.append("  <key>");
                this.escape(sb, record.getMessage());
                sb.append("</key>\n");
                sb.append("  <catalog>");
                this.escape(sb, record.getResourceBundleName());
                sb.append("</catalog>\n");
                Object[] parameters = record.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    sb.append("  <param>");
                    try {
                        this.escape(sb, parameters[i].toString());
                    }
                    catch (Exception ex) {
                        sb.append("???");
                    }
                    sb.append("</param>\n");
                }
            }
            catch (Exception parameters) {
                // empty catch block
            }
        }
        if (record.getThrown() != null) {
            Throwable th = record.getThrown();
            sb.append("  <exception>\n");
            sb.append("    <message>");
            this.escape(sb, th.toString());
            sb.append("</message>\n");
            if (record.getLevel().intValue() == Level.SEVERE.intValue() || record.getLevel().intValue() <= Level.WARNING.intValue() && record.shouldLogExceptionStackTrace()) {
                StackTraceElement[] trace = th.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    StackTraceElement frame = trace[i];
                    sb.append("    <frame>\n");
                    sb.append("      <class>");
                    this.escape(sb, frame.getClassName());
                    sb.append("</class>\n");
                    sb.append("      <method>");
                    this.escape(sb, frame.getMethodName());
                    sb.append("</method>\n");
                    if (frame.getLineNumber() >= 0) {
                        sb.append("      <line>");
                        sb.append(frame.getLineNumber());
                        sb.append("</line>\n");
                    }
                    sb.append("    </frame>\n");
                }
            }
            sb.append("  </exception>\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }
}

