/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.internal.LogicalContainerAwareReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;

public class XcoreLogicalContainerAwareReentrantTypeResolver
extends LogicalContainerAwareReentrantTypeResolver {
    @Inject
    protected XcoreMapper mapper;
    protected Set<EObject> handledExpressions;

    public JvmTypeReference getExtendedClass(JvmDeclaredType type) {
        JvmTypeReference result = null;
        String identifier = type.getIdentifier();
        boolean ignoreSupperInterfaces = identifier != null && identifier.startsWith("$");
        for (JvmTypeReference candidate : type.getSuperTypes()) {
            JvmType jvmType = candidate.getType();
            if (!(jvmType instanceof JvmGenericType)) continue;
            if (!((JvmGenericType)jvmType).isInterface()) {
                return candidate;
            }
            if (result != null || ignoreSupperInterfaces) continue;
            result = candidate;
        }
        return result;
    }

    protected boolean isHandled(XExpression expression) {
        return this.handledExpressions != null && this.handledExpressions.contains(expression);
    }

    protected Map<JvmIdentifiableElement, ResolvedTypes> prepare(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession) {
        this.handledExpressions = null;
        Map result = super.prepare(resolvedTypes, featureScopeSession);
        for (EObject eObject : this.rootedInstances) {
            if (!(eObject instanceof XBlockExpression)) continue;
            if (this.handledExpressions == null) {
                this.handledExpressions = new HashSet<EObject>();
            }
            this.handledExpressions.add(eObject);
            TreeIterator i = eObject.eAllContents();
            while (i.hasNext()) {
                this.handledExpressions.add((EObject)i.next());
            }
        }
        return result;
    }

    protected void clear() {
        super.clear();
        this.handledExpressions = null;
    }
}

