/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ReadOnlyAnnotationPreference;
import org.osgi.framework.Bundle;

public class MarkerAnnotationPreferences {
    private List<AnnotationPreference> fFragments;
    private List<AnnotationPreference> fPreferences;

    public static void initializeDefaultValues(IPreferenceStore store) {
        boolean ignoreAnnotationsPrefPage = store.getBoolean("useAnnotationsPrefPage");
        boolean ignoreQuickDiffPrefPage = store.getBoolean("useQuickDiffPrefPage");
        MarkerAnnotationPreferences preferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference info : preferences.getAnnotationPreferences()) {
            if (ignoreAnnotationsPrefPage && info.isIncludeOnPreferencePage() && MarkerAnnotationPreferences.isComplete(info) || ignoreQuickDiffPrefPage && (info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") || info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") || info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion"))) continue;
            store.setDefault(info.getTextPreferenceKey(), info.getTextPreferenceValue());
            store.setDefault(info.getOverviewRulerPreferenceKey(), info.getOverviewRulerPreferenceValue());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setDefault(info.getVerticalRulerPreferenceKey(), info.getVerticalRulerPreferenceValue());
            }
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)info.getColorPreferenceKey(), (RGB)info.getColorPreferenceValue());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setDefault(info.getShowInNextPrevDropdownToolbarActionKey(), info.isShowInNextPrevDropdownToolbarAction());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setDefault(info.getIsGoToNextNavigationTargetKey(), info.isGoToNextNavigationTarget());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setDefault(info.getIsGoToPreviousNavigationTargetKey(), info.isGoToPreviousNavigationTarget());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setDefault(info.getHighlightPreferenceKey(), info.getHighlightPreferenceValue());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setDefault(info.getTextStylePreferenceKey(), info.getTextStyleValue());
        }
    }

    public static void useAnnotationsPreferencePage(IPreferenceStore store) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        store.putValue("useAnnotationsPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences preferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference info : preferences.getAnnotationPreferences()) {
            if (!info.isIncludeOnPreferencePage() || !MarkerAnnotationPreferences.isComplete(info)) continue;
            store.setToDefault(info.getTextPreferenceKey());
            store.setToDefault(info.getOverviewRulerPreferenceKey());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setToDefault(info.getVerticalRulerPreferenceKey());
            }
            store.setToDefault(info.getColorPreferenceKey());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setToDefault(info.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToNextNavigationTargetKey());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToPreviousNavigationTargetKey());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setToDefault(info.getHighlightPreferenceKey());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setToDefault(info.getTextStylePreferenceKey());
        }
    }

    public static void useQuickDiffPreferencePage(IPreferenceStore store) throws IllegalStateException {
        MarkerAnnotationPreferences.checkAccess();
        store.putValue("useQuickDiffPrefPage", Boolean.toString(true));
        MarkerAnnotationPreferences preferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        for (AnnotationPreference info : preferences.getAnnotationPreferences()) {
            if (!info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffChange") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffAddition") && !info.getAnnotationType().equals("org.eclipse.ui.workbench.texteditor.quickdiffDeletion")) continue;
            store.setToDefault(info.getTextPreferenceKey());
            store.setToDefault(info.getOverviewRulerPreferenceKey());
            if (info.getVerticalRulerPreferenceKey() != null) {
                store.setToDefault(info.getVerticalRulerPreferenceKey());
            }
            store.setToDefault(info.getColorPreferenceKey());
            if (info.getShowInNextPrevDropdownToolbarActionKey() != null) {
                store.setToDefault(info.getShowInNextPrevDropdownToolbarActionKey());
            }
            if (info.getIsGoToNextNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToNextNavigationTargetKey());
            }
            if (info.getIsGoToPreviousNavigationTargetKey() != null) {
                store.setToDefault(info.getIsGoToPreviousNavigationTargetKey());
            }
            if (info.getHighlightPreferenceKey() != null) {
                store.setToDefault(info.getHighlightPreferenceKey());
            }
            if (info.getTextStylePreferenceKey() == null) continue;
            store.setToDefault(info.getTextStylePreferenceKey());
        }
    }

    private static void checkAccess() throws IllegalStateException {
        boolean calledByEditorsUI = StackWalker.getInstance().walk(s -> s.anyMatch(f -> f.getClassName().equals(EditorsUI.class.getCanonicalName())));
        if (!calledByEditorsUI) {
            throw new IllegalStateException();
        }
    }

    public MarkerAnnotationPreferences() {
        this(false);
    }

    private MarkerAnnotationPreferences(boolean initFromPreferences) {
        if (initFromPreferences) {
            this.initializeSharedMakerAnnotationPreferences();
        }
    }

    public List<AnnotationPreference> getAnnotationPreferences() {
        if (this.fPreferences == null) {
            this.initialize();
        }
        return this.fPreferences;
    }

    public List<AnnotationPreference> getAnnotationPreferenceFragments() {
        if (this.fFragments == null) {
            this.initialize();
        }
        return this.fFragments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        EditorsPlugin editorsPlugin = EditorsPlugin.getDefault();
        synchronized (editorsPlugin) {
            if (!EditorsPlugin.getDefault().isMarkerAnnotationPreferencesInitialized()) {
                EditorsPlugin.getDefault().setMarkerAnnotationPreferences(new MarkerAnnotationPreferences(true));
            }
        }
        MarkerAnnotationPreferences sharedPrefs = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.fFragments = this.cloneAnnotationPreferences(sharedPrefs.fFragments);
        this.fPreferences = this.cloneAnnotationPreferences(sharedPrefs.fPreferences);
    }

    private void initializeSharedMakerAnnotationPreferences() {
        this.fFragments = new ArrayList<AnnotationPreference>(2);
        this.fPreferences = new ArrayList<AnnotationPreference>(2);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", "markerAnnotationSpecification");
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                AnnotationPreference spec = this.createSpec(element);
                if (spec != null) {
                    this.fFragments.add(spec);
                }
                if (MarkerAnnotationPreferences.isComplete(spec)) {
                    this.fPreferences.add(spec);
                }
                ++n2;
            }
        }
    }

    private List<AnnotationPreference> cloneAnnotationPreferences(List<AnnotationPreference> annotationPreferences) {
        if (annotationPreferences == null) {
            return null;
        }
        ArrayList<AnnotationPreference> clone = new ArrayList<AnnotationPreference>(annotationPreferences.size());
        Iterator<AnnotationPreference> iter = annotationPreferences.iterator();
        while (iter.hasNext()) {
            clone.add(this.clone(iter.next()));
        }
        return clone;
    }

    private AnnotationPreference clone(AnnotationPreference annotationPreference) {
        if (annotationPreference == null) {
            return null;
        }
        AnnotationPreference clone = new AnnotationPreference();
        if (annotationPreference.getAnnotationType() != null) {
            clone.setAnnotationType(annotationPreference.getAnnotationType());
            clone.merge(annotationPreference);
        }
        return clone;
    }

    private static boolean isComplete(AnnotationPreference spec) {
        return spec.getColorPreferenceKey() != null && spec.getColorPreferenceValue() != null && spec.getTextPreferenceKey() != null && spec.getOverviewRulerPreferenceKey() != null;
    }

    private AnnotationPreference createSpec(IConfigurationElement element) {
        boolean b;
        int i;
        ReadOnlyAnnotationPreference info = new ReadOnlyAnnotationPreference();
        String s = element.getAttribute("annotationType");
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        info.setAnnotationType(s);
        s = element.getAttribute("label");
        if (s != null && !s.trim().isEmpty()) {
            info.setPreferenceLabel(s);
        }
        if ((s = element.getAttribute("markerType")) != null && !s.trim().isEmpty()) {
            info.setMarkerType(s);
        }
        if ((s = element.getAttribute("markerSeverity")) != null && !s.trim().isEmpty()) {
            i = StringConverter.asInt((String)s, (int)0);
            info.setSeverity(i);
        }
        if ((s = element.getAttribute("textPreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setTextPreferenceKey(s);
        }
        if ((s = element.getAttribute("textPreferenceValue")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setTextPreferenceValue(b);
        }
        if ((s = element.getAttribute("highlightPreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setHighlightPreferenceKey(s);
        }
        if ((s = element.getAttribute("highlightPreferenceValue")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setHighlightPreferenceValue(b);
        }
        if ((s = element.getAttribute("overviewRulerPreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setOverviewRulerPreferenceKey(s);
        }
        if ((s = element.getAttribute("overviewRulerPreferenceValue")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setOverviewRulerPreferenceValue(b);
        }
        if ((s = element.getAttribute("verticalRulerPreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setVerticalRulerPreferenceKey(s);
        }
        if ((s = element.getAttribute("verticalRulerPreferenceValue")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)true);
            info.setVerticalRulerPreferenceValue(b);
        }
        if ((s = element.getAttribute("colorPreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setColorPreferenceKey(s);
        }
        if ((s = element.getAttribute("colorPreferenceValue")) != null && !s.trim().isEmpty()) {
            RGB rgb = StringConverter.asRGB((String)s);
            info.setColorPreferenceValue(rgb == null ? new RGB(0, 0, 0) : rgb);
        }
        if ((s = element.getAttribute("presentationLayer")) != null && !s.trim().isEmpty()) {
            i = StringConverter.asInt((String)s, (int)0);
            info.setPresentationLayer(i);
        }
        if ((s = element.getAttribute("contributesToHeader")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setContributesToHeader(b);
        }
        if ((s = element.getAttribute("showInNextPrevDropdownToolbarActionKey")) != null && !s.trim().isEmpty()) {
            info.setShowInNextPrevDropdownToolbarActionKey(s);
        }
        if ((s = element.getAttribute("showInNextPrevDropdownToolbarAction")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setShowInNextPrevDropdownToolbarAction(b);
        }
        if ((s = element.getAttribute("isGoToNextNavigationTargetKey")) != null && !s.trim().isEmpty()) {
            info.setIsGoToNextNavigationTargetKey(s);
        }
        if ((s = element.getAttribute("isGoToNextNavigationTarget")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setIsGoToNextNavigationTarget(b);
        }
        if ((s = element.getAttribute("isGoToPreviousNavigationTargetKey")) != null && !s.trim().isEmpty()) {
            info.setIsGoToPreviousNavigationTargetKey(s);
        }
        if ((s = element.getAttribute("isGoToPreviousNavigationTarget")) != null && !s.trim().isEmpty()) {
            b = StringConverter.asBoolean((String)s, (boolean)false);
            info.setIsGoToPreviousNavigationTarget(b);
        }
        if ((s = element.getAttribute("symbolicIcon")) != null && !s.trim().isEmpty()) {
            info.setSymbolicImageName(s);
        }
        if ((s = element.getAttribute("icon")) != null && !s.trim().isEmpty()) {
            info.setImageDescriptor(this.getImageDescriptor(s, element));
        }
        if ((s = element.getAttribute("quickFixIcon")) != null && !s.trim().isEmpty()) {
            info.setQuickFixImageDescriptor(this.getImageDescriptor(s, element));
        }
        if ((s = element.getAttribute("annotationImageProvider")) != null && !s.trim().isEmpty()) {
            info.setAnnotationImageProviderData(element, "annotationImageProvider");
        }
        if ((s = element.getAttribute("textStylePreferenceKey")) != null && !s.trim().isEmpty()) {
            info.setTextStylePreferenceKey(s);
        }
        if ((s = element.getAttribute("textStylePreferenceValue")) != null && !s.trim().isEmpty()) {
            if ("BOX".equals(s) || "DASHED_BOX".equals(s) || "IBEAM".equals(s) || "SQUIGGLES".equals(s) || "PROBLEM_UNDERLINE".equals(s) || "UNDERLINE".equals(s)) {
                info.setTextStyleValue(s);
            } else {
                info.setTextStyleValue("NONE");
            }
        }
        info.setIncludeOnPreferencePage((s = element.getAttribute("includeOnPreferencePage")) == null || StringConverter.asBoolean((String)s, (boolean)true));
        info.markReadOnly();
        return info;
    }

    private ImageDescriptor getImageDescriptor(String iconPath, IConfigurationElement element) {
        String pluginId = element.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }
}

