/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class TargetDefinitionManager
implements IRegistryChangeListener {
    Map<String, IConfigurationElement> fTargets;
    private static String[] attributes;

    public TargetDefinitionManager() {
        attributes = new String[]{"id", "name"};
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas;
        IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            IExtension extension = delta.getExtension();
            String extensionId = extension.getExtensionPointUniqueIdentifier();
            if (extensionId.equals("org.eclipse.pde.core.targets")) {
                IConfigurationElement[] elems = extension.getConfigurationElements();
                if (delta.getKind() == 1) {
                    this.add(elems);
                } else {
                    this.remove(elems);
                }
            }
            ++n2;
        }
    }

    public IConfigurationElement[] getTargets() {
        if (this.fTargets == null) {
            this.loadElements();
        }
        return this.fTargets.values().toArray(new IConfigurationElement[this.fTargets.size()]);
    }

    public IConfigurationElement[] getSortedTargets() {
        if (this.fTargets == null) {
            this.loadElements();
        }
        IConfigurationElement[] result = this.fTargets.values().toArray(new IConfigurationElement[this.fTargets.size()]);
        Arrays.sort(result, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String value1 = this.getString(o1);
                String value2 = this.getString(o2);
                return value1.compareTo(value2);
            }

            private String getString(IConfigurationElement elem) {
                Object name = elem.getAttribute("name");
                String id = elem.getAttribute("id");
                name = (String)name + " [" + id + "]";
                return name;
            }
        });
        return result;
    }

    public IConfigurationElement getTarget(String id) {
        if (this.fTargets == null) {
            this.loadElements();
        }
        return this.fTargets.get(id);
    }

    private void loadElements() {
        this.fTargets = new LinkedHashMap<String, IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this);
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.pde.core.targets");
        this.add(elements);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValid(IConfigurationElement elem) {
        String value;
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            value = elem.getAttribute(attribute);
            if (value == null) return false;
            if (value.equals("")) {
                return false;
            }
            ++n2;
        }
        value = elem.getAttribute("definition");
        String symbolicName = elem.getDeclaringExtension().getContributor().getName();
        URL url = TargetDefinitionManager.getResourceURL(symbolicName, value);
        if (url == null) return false;
        try {
            Throwable throwable = null;
            stringArray = null;
            try (InputStream s = url.openStream();){
                if (s.available() <= 0) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return false;
    }

    public static URL getResourceURL(String bundleID, String resourcePath) {
        try {
            URL entry;
            Bundle bundle = Platform.getBundle((String)bundleID);
            if (bundle != null && resourcePath != null && (entry = bundle.getEntry(resourcePath)) != null) {
                return FileLocator.toFileURL((URL)entry);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void add(IConfigurationElement[] elems) {
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if (this.isValid(elem)) {
                String id = elem.getAttribute("id");
                this.fTargets.put(id, elem);
            }
            ++n2;
        }
    }

    private void remove(IConfigurationElement[] elems) {
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            this.fTargets.remove(elem.getAttribute("id"));
            ++n2;
        }
    }

    public void shutdown() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

