/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Optional;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.annotations.OSGiAnnotationProcessor;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;

public class ExportPackageAnnotationProcessor
implements OSGiAnnotationProcessor {
    private boolean exportPackage = false;
    private Optional<String> version = Optional.empty();
    private final String packageName;

    public ExportPackageAnnotationProcessor(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void processAnnotation(Annotation annotation, String type) {
        this.exportPackage |= "org.osgi.annotation.bundle.Export".equals(type);
        if ("org.osgi.annotation.versioning.Version".equals(type)) {
            this.version = OSGiAnnotationProcessor.value((Expression)annotation).flatMap(OSGiAnnotationProcessor::stringValue);
        }
    }

    @Override
    public void apply(IBaseModel model) {
        ExportPackageObject packageObject;
        if (this.exportPackage && (packageObject = ExportPackageAnnotationProcessor.getExportPackage(model, this.packageName)) != null) {
            packageObject.setVersion(this.version.orElse(null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ExportPackageObject getExportPackage(IBaseModel model, String packageName) {
        IBaseModel iBaseModel = model;
        if (iBaseModel instanceof IBundlePluginModelBase) {
            IManifestHeader iManifestHeader;
            void pluginModel;
            IBundlePluginModelBase iBundlePluginModelBase = (IBundlePluginModelBase)iBaseModel;
            IBundlePluginModelBase cfr_ignored_0 = (IBundlePluginModelBase)iBaseModel;
            IBundleModel bundleModel = pluginModel.getBundleModel();
            IBundle bundle = bundleModel.getBundle();
            IManifestHeader header = bundle.getManifestHeader("Export-Package");
            if (header == null) {
                bundle.setHeader("Export-Package", packageName);
                header = bundle.getManifestHeader("Export-Package");
            }
            if ((iManifestHeader = header) instanceof ExportPackageHeader) {
                void exportPackageHeader;
                ExportPackageHeader exportPackageHeader2 = (ExportPackageHeader)iManifestHeader;
                ExportPackageHeader cfr_ignored_1 = (ExportPackageHeader)iManifestHeader;
                ExportPackageObject packageObject = exportPackageHeader.getPackage(packageName);
                if (packageObject == null) {
                    return exportPackageHeader.addPackage(packageName);
                }
                return packageObject;
            }
        }
        return null;
    }
}

