/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class TargetRepository
extends BaseRepository
implements RepositoryPlugin {
    private static final TargetRepository instance = new TargetRepository();

    private TargetRepository() {
    }

    public File get(String bsn, aQute.bnd.version.Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        Optional<BundleDescription> description = TargetRepository.getTargetPlatformState().map(state -> state.getBundle(bsn, TargetRepository.convert(version)));
        if (description.isEmpty()) {
            return null;
        }
        Optional<File> bundle = description.map(BundleDescription::getLocation).map(location -> new File((String)location)).filter(File::isFile).or(() -> {
            IPluginModelBase model = PluginRegistry.findModel((BundleDescription)description.get());
            if (model != null) {
                IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
                String installLocation = model.getInstallLocation();
                if (libraries.length == 0) {
                    return Optional.of(new File(installLocation));
                }
                IPluginLibrary[] iPluginLibraryArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginLibrary library = iPluginLibraryArray[n2];
                    if (!"resource".equals(library.getType())) {
                        String name = library.getName();
                        String expandedName = ClasspathUtilCore.expandLibraryName(name);
                        return Optional.of(new File(installLocation, expandedName));
                    }
                    ++n2;
                }
            }
            return Optional.empty();
        });
        if (bundle.isPresent()) {
            File file = bundle.get();
            RepositoryPlugin.DownloadListener[] downloadListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryPlugin.DownloadListener l = downloadListenerArray[n2];
                try {
                    l.success(file);
                }
                catch (Exception exception) {}
                ++n2;
            }
            return file;
        }
        return null;
    }

    public boolean canWrite() {
        return true;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        State state = TargetRepository.getTargetPlatformState().get();
        Hashtable headers = new Hashtable();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JarInputStream jar = new JarInputStream(stream);){
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.entrySet().forEach(e -> {
                String string = headers.put(e.getKey().toString(), e.getValue().toString());
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        BundleDescription description = state.getFactory().createBundleDescription(state, headers, null, state.getHighestBundleId() + 1L);
        RepositoryPlugin.PutResult result = new RepositoryPlugin.PutResult();
        result.alreadyReleased = state.updateBundle(description);
        if (!result.alreadyReleased) {
            state.addBundle(description);
        }
        result.digest = options.digest;
        return result;
    }

    public List<String> list(String glob) throws Exception {
        Stream<String> stream = TargetRepository.bundles(null).map(BundleDescription::getSymbolicName).distinct();
        if (glob != null) {
            Instruction pattern = new Instruction(glob);
            stream = stream.filter(bsn -> pattern.matches(bsn));
        }
        return stream.collect(Collectors.toList());
    }

    public SortedSet<aQute.bnd.version.Version> versions(String bsn) throws Exception {
        return TargetRepository.bundles(bsn).filter(bd -> bd.getLocation() != null).map(bundle -> bundle.getVersion()).map(v -> TargetRepository.convert(v)).collect(Collectors.toCollection(TreeSet::new));
    }

    public String getName() {
        return "PDE Target Platform State";
    }

    public String getLocation() {
        return "pde-target-state";
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return ResourceUtils.findProviders(requirements, this::findProvider);
    }

    public List<Capability> findProvider(Requirement requirement) {
        String namespace = requirement.getNamespace();
        return (List)TargetRepository.bundles(null).flatMap(resource -> ResourceUtils.capabilityStream((Resource)resource, (String)namespace)).filter(ResourceUtils.matcher((Requirement)requirement, ResourceUtils::filterPredicate)).collect(ResourceUtils.toCapabilities());
    }

    private static Stream<BundleDescription> bundles(String bsn) {
        Optional<State> state = TargetRepository.getTargetPlatformState();
        if (state.isEmpty()) {
            return Stream.empty();
        }
        BundleDescription[] bundles = bsn == null ? state.get().getBundles() : state.get().getBundles(bsn);
        return Arrays.stream(bundles);
    }

    private static Optional<State> getTargetPlatformState() {
        PDECore pde = PDECore.getDefault();
        if (pde == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(pde.getModelManager().getState().getState());
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
    }

    private static Version convert(aQute.bnd.version.Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    private static aQute.bnd.version.Version convert(Version v) {
        return new aQute.bnd.version.Version(v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
    }

    public static TargetRepository getTargetRepository() {
        return instance;
    }
}

