/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.spy.sections;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.spy.SpyFormToolkit;
import org.eclipse.pde.internal.runtime.spy.sections.ISpySection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.internal.IActionSetContributionItem;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.WWinPluginAction;
import org.eclipse.ui.menus.CommandContributionItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ActiveMenuSection
implements ISpySection {
    public void build(ScrolledForm form, SpyFormToolkit toolkit, Event event) {
        Object object = event.widget.getData();
        if (object != null) {
            Section section = toolkit.createSection(form.getBody(), 256);
            section.clientVerticalSpacing = 9;
            section.setText(PDERuntimeMessages.SpyDialog_activeSelection_title);
            FormText text = toolkit.createFormText((Composite)section, true);
            section.setClient((Control)text);
            TableWrapData td = new TableWrapData();
            td.align = 128;
            td.grabHorizontal = true;
            section.setLayoutData((Object)td);
            StringBuilder buffer = new StringBuilder();
            buffer.append("<form>");
            if (object instanceof IContributionItem) {
                IContributionItem item = (IContributionItem)object;
                String id = item.getId();
                if (id != null) {
                    buffer.append(toolkit.createIdentifierSection(text, PDERuntimeMessages.ActiveMenuSection_0, new String[]{id}));
                }
                if (object instanceof ContributionItem) {
                    this.createLocationURI(toolkit, object, text, buffer, id);
                }
                this.scan(item, buffer, toolkit, text);
            }
            buffer.append("</form>");
            text.setText(buffer.toString(), true, false);
        }
    }

    private void createLocationURI(SpyFormToolkit toolkit, Object object, FormText text, StringBuilder buffer, String id) {
        ToolBar bar;
        IContributionManager parent = ((ContributionItem)object).getParent();
        if (parent instanceof IMenuManager) {
            String parentId = ((IMenuManager)parent).getId();
            String locationURI = "menu:" + parentId + (String)(id == null ? "?after=additions" : "?after=" + id);
            buffer.append(toolkit.createIdentifierSection(text, PDERuntimeMessages.ActiveMenuSection_7, new String[]{locationURI}));
        } else if (parent instanceof ToolBarManager && (bar = ((ToolBarManager)parent).getControl()).getParent() instanceof CoolBar) {
            CoolItem[] items;
            CoolItem[] coolItemArray = items = ((CoolBar)bar.getParent()).getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object o;
                CoolItem item = coolItemArray[n2];
                if (item.getControl() == bar && (o = item.getData()) instanceof ToolBarContributionItem) {
                    String parentId = ((ToolBarContributionItem)o).getId();
                    String locationURI = "toolbar:" + parentId + (String)(id == null ? "?after=additions" : "?after=" + id);
                    buffer.append(toolkit.createIdentifierSection(text, PDERuntimeMessages.ActiveMenuSection_7, new String[]{locationURI}));
                }
                ++n2;
            }
        }
    }

    private void scan(IContributionItem item, StringBuilder buffer, SpyFormToolkit toolkit, FormText text) {
        if (item instanceof IActionSetContributionItem) {
            IActionSetContributionItem actionItem = (IActionSetContributionItem)item;
            buffer.append(toolkit.createIdentifierSection(text, PDERuntimeMessages.ActiveMenuSection_1, new String[]{actionItem.getActionSetId()}));
        }
        if (item instanceof ActionContributionItem) {
            this.createActionContributionItemText(item, buffer, toolkit, text);
        } else if (item instanceof SubContributionItem) {
            SubContributionItem subItem = (SubContributionItem)item;
            this.scan(subItem.getInnerItem(), buffer, toolkit, text);
        } else if (item instanceof CommandContributionItem) {
            CommandContributionItem contributionItem = (CommandContributionItem)item;
            Command command = contributionItem.getCommand().getCommand();
            buffer.append(toolkit.createClassSection(text, PDERuntimeMessages.ActiveMenuSection_2, command.getClass()));
            buffer.append(toolkit.createClassSection(text, PDERuntimeMessages.ActiveMenuSection_3, command.getHandler().getClass()));
        }
    }

    private void createActionContributionItemText(Object object, StringBuilder buffer, SpyFormToolkit toolkit, FormText text) {
        ActionContributionItem actionItem = (ActionContributionItem)object;
        IAction action = actionItem.getAction();
        String id = action.getActionDefinitionId();
        if (id != null) {
            buffer.append(toolkit.createIdentifierSection(text, PDERuntimeMessages.ActiveMenuSection_4, new String[]{action.getActionDefinitionId()}));
        }
        if (action instanceof PluginAction) {
            PluginAction pluginAction = (PluginAction)action;
            Class<?> clazz = pluginAction.getClass();
            this.createActionContributionItemText(object, buffer, toolkit, text, clazz, pluginAction);
        } else {
            Class<?> clazz = action.getClass();
            buffer.append(toolkit.createClassSection(text, PDERuntimeMessages.ActiveMenuSection_5, clazz));
            Bundle bundle = FrameworkUtil.getBundle(clazz);
            toolkit.generatePluginDetailsText(bundle, null, "meow", buffer, text);
        }
    }

    private void createActionContributionItemText(Object object, StringBuilder buffer, SpyFormToolkit toolkit, FormText text, Class<?> clazz, PluginAction pluginAction) {
        block5: {
            try {
                Field field;
                RetargetAction retargetAction = null;
                IActionDelegate delegate = null;
                if (pluginAction instanceof WWinPluginAction) {
                    field = clazz.getDeclaredField("retargetAction");
                    field.setAccessible(true);
                    retargetAction = (RetargetAction)field.get(pluginAction);
                }
                if (retargetAction == null) {
                    field = clazz.getDeclaredField("delegate");
                    field.setAccessible(true);
                    delegate = (IActionDelegate)field.get(pluginAction);
                    if (delegate == null) {
                        Method method = clazz.getDeclaredMethod("createDelegate", new Class[0]);
                        method.setAccessible(true);
                        method.invoke((Object)pluginAction, new Object[0]);
                        delegate = (IActionDelegate)field.get(pluginAction);
                    }
                }
                buffer.append(toolkit.createClassSection(text, PDERuntimeMessages.ActiveMenuSection_6, retargetAction == null ? delegate.getClass() : retargetAction.getActionHandler().getClass()));
                Bundle bundle = FrameworkUtil.getBundle(clazz);
                toolkit.generatePluginDetailsText(bundle, null, "menu item", buffer, text);
            }
            catch (Exception exception) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null) break block5;
                this.createActionContributionItemText(object, buffer, toolkit, text, superclass, pluginAction);
            }
        }
    }

    @Override
    public void build(ScrolledForm form, SpyFormToolkit toolkit, ExecutionEvent event) {
    }
}

