/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.commands.CommandComposerPart;
import org.eclipse.pde.internal.ui.commands.CommandCopyFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandDetails {
    private final HashMap<IParameter, String> fParameterToValue = new HashMap();
    private final ArrayList<ObjectParameterControl> fObjectParamList = new ArrayList();
    private final ArrayList<ValuesParameterControl> fValueParamList = new ArrayList();
    private final ArrayList<TextParameterControl> fTextParamList = new ArrayList();
    private final CommandComposerPart fCCP;
    private final FormToolkit fToolkit;
    private Command fSelectedCommand;
    private ParameterizedCommand fPreSel;
    private Text fComIDT;
    private Text fComPrev;
    private Button fSurroundCopyText;
    private Combo fFilterCombo;
    private Composite fParamComposite;
    private Composite fParamParent;
    private Label fParamLabel;
    private ImageHyperlink fCopyLink;
    private ImageHyperlink fExecLink;

    public CommandDetails(CommandComposerPart cv, Composite parent) {
        this.fCCP = cv;
        this.fToolkit = cv.getToolkit();
        this.createCommandDetails(parent);
    }

    private void createCommandDetails(Composite parent) {
        Composite c = this.fCCP.createComposite(parent, 1808, 1, true, 5);
        Section section = this.fToolkit.createSection(c, 256);
        section.setText(PDEUIMessages.CommandDetails_groupName);
        section.setLayoutData((Object)new GridData(1808));
        Composite comp = this.fCCP.createComposite((Composite)section);
        this.createBasicInfo(comp);
        if (this.fCCP.getFilterType() == CommandComposerPart.F_FILTER_NOT_SET) {
            this.createPreviewLabelComp(comp);
        }
        this.createParameters(comp);
        section.setClient((Control)comp);
        this.createLinks(c);
    }

    private void createBasicInfo(Composite parent) {
        Composite comp = this.fCCP.createComposite(parent, 768, 2, false, 0);
        this.fToolkit.createLabel(comp, PDEUIMessages.CommandDetails_id);
        this.fComIDT = this.fToolkit.createText(comp, PDEUIMessages.CommandDetails_noComSelected, 2048);
        this.fComIDT.setEditable(false);
        this.fComIDT.setLayoutData((Object)new GridData(768));
    }

    private void createParameters(Composite parent) {
        Composite comp = this.fCCP.createComposite(parent, 768, 1, false, 0);
        this.fParamLabel = this.fToolkit.createLabel(comp, PDEUIMessages.CommandDetails_noParameters);
        this.fParamLabel.setLayoutData((Object)new GridData(768));
        this.fParamParent = parent;
        this.createBlankParamComp();
    }

    private void createLinks(Composite parent) {
        Composite comp = this.fCCP.createComposite(parent, 896, 1, false, 0);
        this.fExecLink = this.fToolkit.createImageHyperlink(comp, 0);
        Image execImage = PDEPluginImages.DESC_RUN_EXC.createImage();
        this.fExecLink.setImage(execImage);
        this.fExecLink.setText(PDEUIMessages.CommandDetails_executeText);
        this.fExecLink.setToolTipText(PDEUIMessages.CommandDetails_execute);
        this.fExecLink.addHyperlinkListener((IHyperlinkListener)new ExecCommand());
        this.fExecLink.setLayoutData((Object)new GridData(128));
        this.fExecLink.setVisible(false);
        this.fExecLink.addDisposeListener(e -> execImage.dispose());
        this.fCopyLink = this.fToolkit.createImageHyperlink(comp, 0);
        Image clipImage = PDEPluginImages.DESC_CLIPBOARD.createImage();
        this.fCopyLink.setImage(clipImage);
        this.fCopyLink.setText(PDEUIMessages.CommandDetails_copyToClipboard);
        this.fCopyLink.setToolTipText(PDEUIMessages.CommandDetails_copytooltip);
        this.fCopyLink.addHyperlinkListener((IHyperlinkListener)new CopyToClipboard());
        this.fCopyLink.setLayoutData((Object)new GridData(128));
        this.fCopyLink.setVisible(false);
        this.fCopyLink.addDisposeListener(e -> clipImage.dispose());
    }

    private void createPreviewLabelComp(Composite parent) {
        CommandCopyFilter[] filters;
        Composite preLabelComp = this.fCCP.createComposite(parent, 768, 3, false, 0);
        this.fToolkit.createLabel(preLabelComp, PDEUIMessages.CommandDetails_preview, 0).setLayoutData((Object)new GridData(768));
        this.fSurroundCopyText = this.fToolkit.createButton(preLabelComp, PDEUIMessages.CommandDetails_includeMarkup, 32);
        this.fSurroundCopyText.setToolTipText(PDEUIMessages.CommandDetails_markupTooltip);
        this.fSurroundCopyText.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updatePreviewText()));
        this.fFilterCombo = new Combo(preLabelComp, 12);
        CommandCopyFilter[] commandCopyFilterArray = filters = CommandCopyFilter.getFilters();
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            CommandCopyFilter filter = commandCopyFilterArray[n2];
            this.fFilterCombo.add(filter.getLabelText());
            ++n2;
        }
        this.fFilterCombo.select(CommandCopyFilter.indexOf(CommandCopyFilter.NONE));
        this.fFilterCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updatePreviewText()));
        this.fToolkit.adapt((Control)this.fFilterCombo, true, true);
        this.fComPrev = this.fToolkit.createText(parent, "", 2626);
        GridData gd = new GridData(768);
        gd.heightHint = 60;
        this.fComPrev.setLayoutData((Object)gd);
        this.fComPrev.setEditable(false);
    }

    protected ParameterizedCommand buildParameterizedCommand() {
        ArrayList<Parameterization> list = new ArrayList<Parameterization>(this.fParameterToValue.size());
        for (Map.Entry<IParameter, String> entry : this.fParameterToValue.entrySet()) {
            list.add(new Parameterization(entry.getKey(), entry.getValue()));
        }
        Parameterization[] parameterizations = list.toArray(new Parameterization[list.size()]);
        ParameterizedCommand pCommand = new ParameterizedCommand(this.fSelectedCommand, parameterizations);
        return pCommand;
    }

    private String getFilteredCommand() {
        int index;
        String markupLabel;
        ParameterizedCommand pCommand = this.buildParameterizedCommand();
        String serializedCommand = pCommand.serialize();
        try {
            markupLabel = this.fSelectedCommand.getName();
        }
        catch (NotDefinedException notDefinedException) {
            markupLabel = null;
        }
        boolean surroundWithMarkup = false;
        if (this.fCCP.getFilterType() == CommandComposerPart.F_FILTER_NOT_SET) {
            surroundWithMarkup = this.fSurroundCopyText.getSelection();
            index = this.fFilterCombo.getSelectionIndex();
        } else {
            index = this.fCCP.getFilterType();
        }
        CommandCopyFilter ccf = CommandCopyFilter.getFilter(index);
        return ccf.filter(serializedCommand, surroundWithMarkup, markupLabel);
    }

    protected void dispose() {
        int i = 0;
        while (i < this.fObjectParamList.size()) {
            this.fObjectParamList.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.fValueParamList.size()) {
            this.fValueParamList.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.fTextParamList.size()) {
            this.fTextParamList.get(i).dispose();
            ++i;
        }
    }

    private void populateParams(Command command, Object selectedObject) throws NotDefinedException {
        this.createBlankParamComp();
        IParameter[] parameters = command.getParameters();
        if (parameters == null || parameters.length == 0) {
            this.fParamLabel.setText(PDEUIMessages.CommandDetails_noParameters);
        } else {
            this.fParamLabel.setText(PDEUIMessages.CommandDetails_numParams);
            Composite paramLine = this.fToolkit.createComposite(this.fParamComposite);
            GridLayout paramLineLayout = new GridLayout();
            paramLine.setLayoutData((Object)new GridData(768));
            paramLineLayout.numColumns = 3;
            paramLineLayout.marginHeight = 0;
            paramLine.setLayout((Layout)paramLineLayout);
            IParameter[] iParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter parameter = iParameterArray[n2];
                Object nameText = parameter.getName();
                if (!parameter.isOptional()) {
                    nameText = (String)nameText + "*";
                }
                this.fToolkit.createLabel(paramLine, NLS.bind((String)PDEUIMessages.CommandDetails_param, (Object)nameText));
                IParameterValues parameterValues = this.getParameterValues(parameter);
                if (parameterValues != null) {
                    Combo parameterValuesCombo = new Combo(paramLine, 12);
                    parameterValuesCombo.setLayoutData((Object)new GridData(768));
                    this.fToolkit.adapt((Control)parameterValuesCombo, true, true);
                    Map values = parameterValues.getParameterValues();
                    for (String key : values.keySet()) {
                        parameterValuesCombo.add(key);
                    }
                    Button clearButton = this.fToolkit.createButton(paramLine, PDEUIMessages.CommandDetails_clear, 8);
                    this.fValueParamList.add(new ValuesParameterControl(parameter, values, parameterValuesCombo, clearButton));
                } else {
                    ParameterType parameterType = command.getParameterType(parameter.getId());
                    if (parameterType != null && parameterType.getValueConverter() != null) {
                        parameterText = this.fToolkit.createText(paramLine, "", 2052);
                        gd = new GridData(768);
                        gd.horizontalSpan = 2;
                        parameterText.setLayoutData((Object)gd);
                        this.fObjectParamList.add(new ObjectParameterControl(parameter, parameterType.getValueConverter(), parameterText, selectedObject));
                    } else {
                        parameterText = this.fToolkit.createText(paramLine, "", 2052);
                        gd = new GridData(768);
                        gd.horizontalSpan = 2;
                        parameterText.setLayoutData((Object)gd);
                        this.fTextParamList.add(new TextParameterControl(parameter, parameterText));
                    }
                }
                ++n2;
            }
        }
        this.fPreSel = null;
        this.fParamParent.layout();
    }

    private IParameterValues getParameterValues(IParameter parameter) {
        try {
            return parameter.getValues();
        }
        catch (ParameterValuesException parameterValuesException) {
            return null;
        }
    }

    public void showDetailsFor(Object object) {
        if (object instanceof ParameterizedCommand) {
            this.fPreSel = (ParameterizedCommand)object;
            object = this.fPreSel.getCommand();
        }
        if (!(object instanceof Command)) {
            this.resetAllFields();
            return;
        }
        this.fSelectedCommand = (Command)object;
        this.fComIDT.setText(this.fSelectedCommand.getId());
        this.fParameterToValue.clear();
        this.fObjectParamList.clear();
        this.fValueParamList.clear();
        this.fExecLink.setVisible(this.fSelectedCommand.isEnabled());
        this.fCopyLink.setVisible(true);
        try {
            this.populateParams(this.fSelectedCommand, object);
        }
        catch (NotDefinedException notDefinedException) {
            this.createNoParamComp();
        }
        this.updatePreviewText();
    }

    private void resetAllFields() {
        this.fSelectedCommand = null;
        this.fComIDT.setText(PDEUIMessages.CommandDetails_noComSelected);
        this.fParamLabel.setText(PDEUIMessages.CommandDetails_noParameters);
        if (this.fComPrev != null) {
            this.fComPrev.setText("");
        }
        this.fExecLink.setVisible(false);
        this.fCopyLink.setVisible(false);
        this.fParameterToValue.clear();
        this.fObjectParamList.clear();
        this.fValueParamList.clear();
        this.createNoParamComp();
    }

    private void createNoParamComp() {
        this.createBlankParamComp();
        this.fParamParent.layout();
    }

    private void createBlankParamComp() {
        if (this.fParamComposite != null) {
            this.fParamComposite.dispose();
        }
        this.fParamComposite = this.fCCP.createComposite(this.fParamParent, 1808, 1, true, 0);
    }

    private void updatePreviewText() {
        if (this.fComPrev != null) {
            this.fComPrev.setText(this.getFilteredCommand());
        }
    }

    protected Command getCommand() {
        return this.fSelectedCommand;
    }

    public String getCommandName() {
        if (this.fSelectedCommand != null) {
            try {
                return this.fSelectedCommand.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return this.fSelectedCommand.getId();
            }
        }
        return null;
    }

    public String getSerializedString() {
        if (this.fSelectedCommand != null) {
            return this.getFilteredCommand();
        }
        return null;
    }

    public HashMap<IParameter, String> getParameters() {
        if (this.fSelectedCommand != null) {
            return this.fParameterToValue;
        }
        return null;
    }

    private IHandlerService getGlobalHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    private class CopyToClipboard
    extends HyperlinkAdapter {
        private CopyToClipboard() {
        }

        public void linkActivated(HyperlinkEvent e) {
            String filteredCommand = CommandDetails.this.getFilteredCommand();
            Object[] data = new Object[]{filteredCommand};
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
            Clipboard clipboard = new Clipboard(null);
            clipboard.setContents(data, transfers, 1);
            clipboard.dispose();
        }
    }

    private class ExecCommand
    extends HyperlinkAdapter {
        private ExecCommand() {
        }

        public void linkActivated(HyperlinkEvent e) {
            ParameterizedCommand pCommand = CommandDetails.this.buildParameterizedCommand();
            try {
                IHandlerService service = CommandDetails.this.getGlobalHandlerService();
                IEvaluationContext context = CommandDetails.this.fCCP.getSnapshotContext();
                Object obj = service.executeCommandInContext(pCommand, null, context);
                String resultString = null;
                if (obj instanceof String) {
                    resultString = (String)obj;
                } else {
                    ParameterType returnType = pCommand.getCommand().getReturnType();
                    if (returnType != null && returnType.getValueConverter() != null) {
                        resultString = returnType.getValueConverter().convertToString(obj);
                    }
                }
                if (resultString != null) {
                    MessageDialog.openInformation((Shell)CommandDetails.this.fComIDT.getShell(), (String)PDEUIMessages.CommandDetails_commandResult, (String)resultString);
                }
            }
            catch (CommandException ex) {
                MessageDialog.openError((Shell)CommandDetails.this.fComIDT.getShell(), (String)PDEUIMessages.CommandDetails_execError, (String)ex.toString());
            }
        }
    }

    private class ObjectParameterControl
    implements ModifyListener {
        private final IParameter fParameter;
        private final AbstractParameterValueConverter fValueConverter;
        private final Text fParameterText;

        public ObjectParameterControl(IParameter parameter, AbstractParameterValueConverter valueConverter, Text parameterText, Object selectedObject) {
            Object obj;
            this.fParameter = parameter;
            this.fValueConverter = valueConverter;
            this.fParameterText = parameterText;
            this.fParameterText.addModifyListener((ModifyListener)this);
            if (selectedObject != null) {
                this.setParameterText(selectedObject);
            }
            if (CommandDetails.this.fPreSel != null && (obj = CommandDetails.this.fPreSel.getParameterMap().get(parameter.getId())) != null) {
                this.fParameterText.setText(obj.toString());
            }
        }

        public void modifyText(ModifyEvent e) {
            String text = this.fParameterText.getText();
            if (text == null || text.trim().equals("")) {
                CommandDetails.this.fParameterToValue.remove(this.fParameter);
            } else {
                CommandDetails.this.fParameterToValue.put(this.fParameter, text);
            }
            CommandDetails.this.updatePreviewText();
            this.validate();
        }

        private void setParameterText(Object selectedObject) {
            try {
                String converted = this.fValueConverter.convertToString(selectedObject);
                if (converted != null) {
                    this.fParameterText.setText(converted);
                }
            }
            catch (ParameterValueConversionException parameterValueConversionException) {}
        }

        protected void dispose() {
            if (!this.fParameterText.isDisposed()) {
                this.fParameterText.removeModifyListener((ModifyListener)this);
            }
        }

        private void validate() {
            String text = this.fParameterText.getText();
            String error = null;
            if (text.length() > 0) {
                try {
                    this.fValueConverter.convertToObject(text);
                }
                catch (ParameterValueConversionException e1) {
                    error = e1.getMessage();
                }
            }
            if (error == null) {
                CommandDetails.this.fCCP.setMessage(null, 0);
            } else {
                CommandDetails.this.fCCP.setMessage(NLS.bind((String)PDEUIMessages.CommandDetails_paramValueMessage, (Object)this.fParameter.getName(), (Object)error), 2);
            }
        }
    }

    private class TextParameterControl
    implements ModifyListener {
        private final IParameter fParameter;
        private final Text fParameterText;

        public TextParameterControl(IParameter parameter, Text parameterText) {
            Object obj;
            this.fParameter = parameter;
            this.fParameterText = parameterText;
            this.fParameterText.addModifyListener((ModifyListener)this);
            if (CommandDetails.this.fPreSel != null && (obj = CommandDetails.this.fPreSel.getParameterMap().get(parameter.getId())) != null) {
                this.fParameterText.setText(obj.toString());
            }
        }

        public void modifyText(ModifyEvent e) {
            String text = this.fParameterText.getText();
            if (text == null || text.trim().equals("")) {
                CommandDetails.this.fParameterToValue.remove(this.fParameter);
            } else {
                CommandDetails.this.fParameterToValue.put(this.fParameter, text);
            }
            CommandDetails.this.updatePreviewText();
        }

        public void dispose() {
            if (!this.fParameterText.isDisposed()) {
                this.fParameterText.removeModifyListener((ModifyListener)this);
            }
        }
    }

    private class ValuesParameterControl
    extends SelectionAdapter
    implements ModifyListener {
        private final IParameter fParameter;
        private final Map<String, Object> fValues;
        private final Combo fValuesCombo;
        private final Button fClearButton;

        public ValuesParameterControl(IParameter parameter, Map<String, Object> values, Combo valuesCombo, Button clearButton) {
            Object obj;
            this.fParameter = parameter;
            this.fValues = values;
            this.fValuesCombo = valuesCombo;
            this.fValuesCombo.addModifyListener((ModifyListener)this);
            if (CommandDetails.this.fPreSel != null && this.fValues != null && (obj = CommandDetails.this.fPreSel.getParameterMap().get(parameter.getId())) != null) {
                for (Map.Entry<String, Object> entry : this.fValues.entrySet()) {
                    if (!obj.equals(entry.getValue())) continue;
                    this.fValuesCombo.setText(entry.getKey());
                    break;
                }
            }
            this.fClearButton = clearButton;
            this.fClearButton.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.fValuesCombo.deselectAll();
            CommandDetails.this.fParameterToValue.remove(this.fParameter);
        }

        public void modifyText(ModifyEvent e) {
            String key = this.fValuesCombo.getText();
            String value = (String)this.fValues.get(key);
            if (value == null) {
                CommandDetails.this.fParameterToValue.remove(this.fParameter);
            } else {
                CommandDetails.this.fParameterToValue.put(this.fParameter, value);
            }
            CommandDetails.this.updatePreviewText();
        }

        protected void dispose() {
            if (!this.fValuesCombo.isDisposed()) {
                this.fValuesCombo.removeModifyListener((ModifyListener)this);
            }
            if (!this.fClearButton.isDisposed()) {
                this.fClearButton.removeSelectionListener((SelectionListener)this);
            }
        }
    }
}

