/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class PluginSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.PluginSelectionDialog";
    private final IPluginModelBase[] fModels;
    String originalPattern;

    public PluginSelectionDialog(Shell parentShell, boolean includeFragments, boolean multipleSelection) {
        this(parentShell, PluginSelectionDialog.getElements(includeFragments), multipleSelection);
    }

    public PluginSelectionDialog(Shell parentShell, IPluginModelBase[] models, boolean multipleSelection) {
        super(parentShell, multipleSelection);
        this.fModels = models;
        this.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        this.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.pde.doc.user.plugin_selection");
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    private static IPluginModelBase[] getElements(boolean includeFragments) {
        return PluginRegistry.getActiveModels((boolean)includeFragments);
    }

    public static HashSet<String> getExistingImports(IPluginModelBase model, boolean includeImportPkg) {
        IFragment fragment;
        IPluginModelBase host;
        HashSet<String> existingImports = new HashSet<String>();
        PluginSelectionDialog.addSelfAndDirectImports(existingImports, model);
        if (model instanceof IFragmentModel && (host = PluginRegistry.findModel((String)(fragment = ((IFragmentModel)model).getFragment()).getPluginId())) instanceof IPluginModel) {
            PluginSelectionDialog.addSelfAndDirectImports(existingImports, host);
        }
        if (includeImportPkg && model instanceof IBundlePluginModelBase) {
            PluginSelectionDialog.addImportedPackages((IBundlePluginModelBase)model, existingImports);
        }
        return existingImports;
    }

    private static void addSelfAndDirectImports(HashSet<String> set, IPluginModelBase model) {
        IPluginImport[] imports;
        if (model == null) {
            return;
        }
        set.add(model.getPluginBase().getId());
        IPluginImport[] iPluginImportArray = imports = model.getPluginBase().getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport pImport = iPluginImportArray[n2];
            String id = pImport.getId();
            if (set.add(id)) {
                PluginSelectionDialog.addReexportedImport(set, id);
            }
            ++n2;
        }
    }

    private static void addReexportedImport(HashSet<String> set, String id) {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null) {
            IPluginImport[] imports;
            IPluginImport[] iPluginImportArray = imports = model.getPluginBase().getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport pImport = iPluginImportArray[n2];
                if (pImport.isReexported() && set.add(pImport.getId())) {
                    PluginSelectionDialog.addReexportedImport(set, pImport.getId());
                }
                ++n2;
            }
        }
    }

    private static void addImportedPackages(IBundlePluginModelBase base, HashSet<String> existingImports) {
        HashMap<String, ImportPackageObject> map = PluginSelectionDialog.getImportPackages(base);
        if (map == null) {
            return;
        }
        ExportPackageDescription[] exported = PDECore.getDefault().getModelManager().getState().getState().getExportedPackages();
        int i = 0;
        while (i < exported.length) {
            ImportPackageObject ipo = map.get(exported[i].getName());
            if (ipo != null) {
                String version = ipo.getVersion();
                if (version != null) {
                    try {
                        if (!new VersionRange(version).isIncluded(exported[i].getVersion())) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    existingImports.add(exported[i].getSupplier().getSymbolicName());
                }
            }
            ++i;
        }
    }

    private static HashMap<String, ImportPackageObject> getImportPackages(IBundlePluginModelBase base) {
        ImportPackageHeader header;
        IBundleModel bmodel = base.getBundleModel();
        if (bmodel != null && (header = (ImportPackageHeader)bmodel.getBundle().getManifestHeader("Import-Package")) != null) {
            ImportPackageObject[] packages;
            HashMap<String, ImportPackageObject> map = new HashMap<String, ImportPackageObject>();
            ImportPackageObject[] importPackageObjectArray = packages = header.getPackages();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageObject importPackage = importPackageObjectArray[n2];
                map.put(importPackage.getName(), importPackage);
                ++n2;
            }
            return map;
        }
        return null;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PluginSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase fModel = iPluginModelBaseArray[n2];
            contentProvider.add((Object)fModel, itemsFilter);
            progressMonitor.worked(1);
            ++n2;
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    /*
     * WARNING - void declaration
     */
    public String getElementName(Object item) {
        Object object = item;
        if (object instanceof IPluginModelBase) {
            void model;
            IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
            return model.getPluginBase().getId();
        }
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        return new PluginSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ManifestEditor_addActionText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private class PluginSearchComparator
    implements Comparator<Object> {
        private PluginSearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IPluginModelBase) {
                return 100;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        private int compareSimilarObjects(Object o1, Object o2) {
            Object object = o1;
            if (object instanceof IPluginModelBase) {
                IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
                IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
                if (o2 instanceof IPluginModelBase) {
                    void ipmb1;
                    IPluginModelBase ipmb2 = (IPluginModelBase)o2;
                    return this.comparePlugins(ipmb1.getPluginBase(), ipmb2.getPluginBase());
                }
            }
            return 0;
        }

        private int comparePlugins(IPluginBase ipmb1, IPluginBase ipmb2) {
            if (ipmb1.getId().startsWith(PluginSelectionDialog.this.originalPattern) && !ipmb2.getId().startsWith(PluginSelectionDialog.this.originalPattern)) {
                return -1;
            }
            if (!ipmb1.getId().startsWith(PluginSelectionDialog.this.originalPattern) && ipmb2.getId().startsWith(PluginSelectionDialog.this.originalPattern)) {
                return 1;
            }
            return ipmb1.getId().compareTo(ipmb2.getId());
        }
    }

    private class PluginSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public PluginSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)PluginSelectionDialog.this);
            PluginSelectionDialog.this.originalPattern = this.patternMatcher.getPattern();
            Object pattern = PluginSelectionDialog.this.originalPattern;
            if (((String)pattern).indexOf(42) != 0 && ((String)pattern).indexOf(63) != 0 && ((String)pattern).indexOf(46) != 0) {
                pattern = "*" + (String)pattern;
                this.patternMatcher.setPattern((String)pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchItem(Object item) {
            String id = null;
            Object object = item;
            if (object instanceof IPluginModelBase) {
                void model;
                IPluginModelBase iPluginModelBase = (IPluginModelBase)object;
                IPluginModelBase cfr_ignored_0 = (IPluginModelBase)object;
                id = model.getPluginBase().getId();
            }
            return this.matches(id);
        }
    }
}

