/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.iproduct.IIntroInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.product.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.product.PluginSection;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.product.ProductIntroWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class IntroSection
extends PDESection {
    private ComboPart fIntroCombo;
    private IFile fManifest;
    private String[] fAvailableIntroIds;
    private static final String INTRO_PLUGIN_ID = "org.eclipse.ui.intro";
    private static final double NEW_INTRO_SUPPORT_VERSION = 3.1;

    public IntroSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.IntroSection_sectionText);
        section.setDescription(PDEUIMessages.IntroSection_sectionDescription);
        boolean canCreateNew = TargetPlatformHelper.getTargetVersion() >= 3.1;
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, canCreateNew ? 3 : 2));
        client.setLayoutData((Object)new GridData(768));
        Label label = toolkit.createLabel(client, PDEUIMessages.IntroSection_introLabel, 64);
        GridData td = new GridData();
        td.horizontalSpan = canCreateNew ? 3 : 2;
        label.setLayoutData((Object)td);
        Label introLabel = toolkit.createLabel(client, PDEUIMessages.IntroSection_introInput);
        introLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fIntroCombo = new ComboPart();
        this.fIntroCombo.createControl(client, toolkit, 8);
        td = new GridData(768);
        this.fIntroCombo.getControl().setLayoutData((Object)td);
        this.loadManifestAndIntroIds(false);
        if (this.fAvailableIntroIds != null) {
            this.fIntroCombo.setItems(this.fAvailableIntroIds);
        }
        this.fIntroCombo.add("");
        this.fIntroCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleSelection()));
        if (canCreateNew) {
            Button button = toolkit.createButton(client, PDEUIMessages.IntroSection_new, 8);
            button.setEnabled(this.isEditable());
            button.setLayoutData((Object)new GridData(4));
            button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleNewIntro()));
        }
        this.fIntroCombo.getControl().setEnabled(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void handleSelection() {
        if (!this.productDefined()) {
            this.fIntroCombo.setText("");
            return;
        }
        this.getIntroInfo().setId(this.fIntroCombo.getSelection());
        this.addDependenciesAndPlugins();
    }

    private void loadManifestAndIntroIds(boolean onlyLoadManifest) {
        IExtension[] extensions;
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions(INTRO_PLUGIN_ID, true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block7: {
                    IConfigurationElement element;
                    block8: {
                        String attribute;
                        element = iConfigurationElementArray[n4];
                        if (!"introProductBinding".equals(element.getName()) || (attribute = element.getAttribute("productId")) == null || !attribute.equals(this.getProduct().getProductId())) break block7;
                        if (this.fManifest != null) break block8;
                        IPluginModelBase base = PluginRegistry.findModel((String)extension.getContributor().getName());
                        if (base == null) break block7;
                        this.fManifest = (IFile)base.getUnderlyingResource();
                    }
                    if (onlyLoadManifest) {
                        return;
                    }
                    String introId = element.getAttribute("introId");
                    if (introId != null) {
                        result.add(introId);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.fAvailableIntroIds = result.toArray(new String[result.size()]);
    }

    private void handleNewIntro() {
        boolean needNewProduct = false;
        if (!this.productDefined()) {
            needNewProduct = true;
            MessageDialog mdiag = new MessageDialog(PDEPlugin.getActiveWorkbenchShell(), PDEUIMessages.IntroSection_undefinedProductId, null, PDEUIMessages.IntroSection_undefinedProductIdMessage, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            if (mdiag.open() != 0) {
                return;
            }
        }
        ProductIntroWizard wizard = new ProductIntroWizard(this.getProduct(), needNewProduct);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            String id = wizard.getIntroId();
            this.fIntroCombo.add(id, 0);
            this.fIntroCombo.setText(id);
            this.getIntroInfo().setId(id);
            this.addDependenciesAndPlugins();
        }
    }

    public void refresh() {
        String introId = this.getIntroInfo().getId();
        if (introId == null) {
            this.fIntroCombo.setText("");
        } else {
            this.fIntroCombo.setText(introId);
        }
        super.refresh();
    }

    private IIntroInfo getIntroInfo() {
        IIntroInfo info = this.getProduct().getIntroInfo();
        if (info == null) {
            info = this.getModel().getFactory().createIntroInfo();
            this.getProduct().setIntroInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private boolean productDefined() {
        String id = this.getProduct().getProductId();
        return id != null && !id.equals("");
    }

    private void addDependenciesAndPlugins() {
        IProduct product = this.getProduct();
        if (product.getType() == IProduct.ProductType.BUNDLES) {
            IProductModelFactory factory = product.getModel().getFactory();
            IProductPlugin plugin = factory.createPlugin();
            plugin.setId(INTRO_PLUGIN_ID);
            product.addPlugins(new IProductPlugin[]{plugin});
            boolean includeOptional = false;
            IFormPage page = this.getPage().getEditor().findPage("plugin-dependencies");
            if (page != null) {
                includeOptional = ((DependenciesPage)page).includeOptionalDependencies();
            }
            PluginSection.handleAddRequired(new IProductPlugin[]{plugin}, includeOptional);
        }
        if (this.fManifest == null) {
            this.loadManifestAndIntroIds(true);
        }
        if (this.fManifest != null) {
            this.addRequiredBundle();
        }
    }

    private void addRequiredBundle() {
        ModelModification mod = new ModelModification(this.fManifest){

            /*
             * WARNING - void declaration
             */
            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                void modelBase;
                IBaseModel iBaseModel = model;
                if (!(iBaseModel instanceof IBundlePluginModelBase)) {
                    return;
                }
                IBundlePluginModelBase iBundlePluginModelBase = (IBundlePluginModelBase)iBaseModel;
                IBundlePluginModelBase cfr_ignored_0 = (IBundlePluginModelBase)iBaseModel;
                IBundle bundle = modelBase.getBundleModel().getBundle();
                IManifestHeader header = bundle.getManifestHeader("Require-Bundle");
                if (header instanceof RequireBundleHeader) {
                    RequireBundleObject[] requires;
                    RequireBundleObject[] requireBundleObjectArray = requires = ((RequireBundleHeader)header).getRequiredBundles();
                    int n = requires.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                        if (requiredBundle.getId().equals(IntroSection.INTRO_PLUGIN_ID)) {
                            return;
                        }
                        ++n2;
                    }
                    ((RequireBundleHeader)header).addBundle(IntroSection.INTRO_PLUGIN_ID);
                } else {
                    bundle.setHeader("Require-Bundle", IntroSection.INTRO_PLUGIN_ID);
                }
            }
        };
        PDEModelUtility.modifyModel(mod, null);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

