/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.SchemaCompositorDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaElementDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaElementReferenceDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaIdentifierAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaJavaAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOtherAttributeDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaRootElementDetails;
import org.eclipse.pde.internal.ui.editor.schema.SchemaStringAttributeDetails;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SchemaFormPage
extends PDEFormPage
implements IModelChangedListener {
    public static final String PAGE_ID = "form";
    private ElementSection fSection;
    private final SchemaBlock fBlock = new SchemaBlock();
    private DetailsPart fDetailsPart;
    private ImageHyperlink fImageHyperlinkPreviewRefDoc;
    private ShowDescriptionAction fPreviewAction;

    public SchemaFormPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.SchemaEditor_FormPage_title);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.schema_editor_main";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (schema.isEditable()) {
            form.getToolBarManager().add((IContributionItem)this.createUIControlConPreviewRefDoc());
            form.getToolBarManager().update(true);
        }
        super.createFormContent(managedForm);
        this.fBlock.createContent(managedForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.schema_editor_main");
        this.initialize();
    }

    private ControlContribution createUIControlConPreviewRefDoc() {
        return new ControlContribution("Preview"){

            protected Control createControl(Composite parent) {
                SchemaFormPage.this.createUIImageHyperlinkPreviewRefDoc(parent);
                SchemaFormPage.this.createUIListenerImageHyperlinkPreviewRefDoc();
                return SchemaFormPage.this.fImageHyperlinkPreviewRefDoc;
            }
        };
    }

    private void createUIImageHyperlinkPreviewRefDoc(Composite parent) {
        this.fImageHyperlinkPreviewRefDoc = new ImageHyperlink(parent, 0);
        this.fImageHyperlinkPreviewRefDoc.setText(PDEUIMessages.SchemaEditor_previewLink);
        this.fImageHyperlinkPreviewRefDoc.setUnderlined(true);
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
    }

    private void createUIListenerImageHyperlinkPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkActivatedPreviewRefDoc();
            }

            public void linkEntered(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkEnteredPreviewRefDoc(e.getLabel());
            }

            public void linkExited(HyperlinkEvent e) {
                SchemaFormPage.this.handleLinkExitedPreviewRefDoc();
            }
        });
    }

    private void handleLinkEnteredPreviewRefDoc(String message) {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getActiveForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private void handleLinkExitedPreviewRefDoc() {
        this.fImageHyperlinkPreviewRefDoc.setForeground(this.getManagedForm().getToolkit().getHyperlinkGroup().getForeground());
        this.getEditor().getEditorSite().getActionBars().getStatusLineManager().setMessage(null);
    }

    private void handleLinkActivatedPreviewRefDoc() {
        ISchema schema = (ISchema)((SchemaEditor)this.getEditor()).getAggregateModel();
        if (this.fPreviewAction == null) {
            this.fPreviewAction = new ShowDescriptionAction(schema);
        } else {
            this.fPreviewAction.setSchema(schema);
        }
        this.fPreviewAction.run();
    }

    public void initialize() {
        ISchema schema = (ISchema)this.getModel();
        this.getManagedForm().getForm().setText(schema.getName());
        schema.addModelChangedListener((IModelChangedListener)this);
    }

    @Override
    public void dispose() {
        ISchema schema = (ISchema)this.getModel();
        if (schema != null) {
            schema.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent event) {
        IDetailsPage page;
        if (event.getChangeType() == 3) {
            Object[] change;
            String changeProperty = event.getChangedProperty();
            if (changeProperty != null && changeProperty.equals("name") && (change = event.getChangedObjects()).length > 0 && change[0] instanceof ISchema) {
                this.getManagedForm().getForm().setText(((ISchema)change[0]).getName());
            }
        } else if (event.getChangeType() == 99) {
            this.handleModelEventWorldChanged(event);
        }
        if (this.fSection != null) {
            this.fSection.handleModelChanged(event);
        }
        if ((page = this.fDetailsPart.getCurrentPage()) instanceof IModelChangedListener) {
            ((IModelChangedListener)page).modelChanged(event);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        ISchema schema = (ISchema)this.getModel();
        this.getManagedForm().getForm().setText(schema.getName());
    }

    public class SchemaBlock
    extends PDEMasterDetailsBlock
    implements IDetailsPageProvider {
        public SchemaBlock() {
            super(SchemaFormPage.this);
        }

        @Override
        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            SchemaFormPage.this.fSection = new ElementSection(this.getPage(), parent);
            return SchemaFormPage.this.fSection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            SchemaFormPage.this.fDetailsPart = detailsPart;
            detailsPart.setPageLimit(5);
            detailsPart.registerPage(ISchemaObjectReference.class, (IDetailsPage)new SchemaElementReferenceDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(ISchemaRootElement.class, (IDetailsPage)new SchemaRootElementDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(ISchemaElement.class, (IDetailsPage)new SchemaElementDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(ISchemaCompositor.class, (IDetailsPage)new SchemaCompositorDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(SchemaStringAttributeDetails.class, (IDetailsPage)new SchemaStringAttributeDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(SchemaJavaAttributeDetails.class, (IDetailsPage)new SchemaJavaAttributeDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(SchemaOtherAttributeDetails.class, (IDetailsPage)new SchemaOtherAttributeDetails(SchemaFormPage.this.fSection));
            detailsPart.registerPage(SchemaIdentifierAttributeDetails.class, (IDetailsPage)new SchemaIdentifierAttributeDetails(SchemaFormPage.this.fSection));
            detailsPart.setPageProvider((IDetailsPageProvider)this);
        }

        /*
         * WARNING - void declaration
         */
        public Object getPageKey(Object object) {
            if (object instanceof ISchemaObjectReference) {
                return ISchemaObjectReference.class;
            }
            if (object instanceof ISchemaRootElement) {
                return ISchemaRootElement.class;
            }
            if (object instanceof ISchemaElement) {
                return ISchemaElement.class;
            }
            if (object instanceof ISchemaCompositor) {
                return ISchemaCompositor.class;
            }
            Object object2 = object;
            if (object2 instanceof ISchemaAttribute) {
                void att;
                ISchemaAttribute iSchemaAttribute = (ISchemaAttribute)object2;
                ISchemaAttribute cfr_ignored_0 = (ISchemaAttribute)object2;
                int kind = att.getKind();
                switch (kind) {
                    case 1: {
                        return SchemaJavaAttributeDetails.class;
                    }
                    case 3: {
                        return SchemaIdentifierAttributeDetails.class;
                    }
                    case 0: {
                        if (!att.getType().getName().equals(ISchemaAttribute.TYPES[1])) break;
                        return SchemaStringAttributeDetails.class;
                    }
                }
                return SchemaOtherAttributeDetails.class;
            }
            return null;
        }

        public IDetailsPage getPage(Object object) {
            return null;
        }
    }
}

