/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.AbstractHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;

public class TranslationHyperlink
extends AbstractHyperlink {
    private final IModel fBase;
    private boolean fOpened;

    public TranslationHyperlink(IRegion region, String element, IModel base) {
        super(region, element);
        this.fBase = base;
    }

    private String getLocalization() {
        String localiz = null;
        if (this.fBase instanceof PluginModelBase) {
            if (((PluginModelBase)this.fBase).getNLResourceHelper() != null) {
                localiz = ((PluginModelBase)this.fBase).getNLResourceHelper().getNLFileBasePath();
            }
        } else if (this.fBase instanceof IPluginModelBase) {
            localiz = PDEManager.getBundleLocalization((IPluginModelBase)((IPluginModelBase)this.fBase));
        } else if (this.fBase instanceof IBundleModel) {
            localiz = ((IBundleModel)this.fBase).getBundle().getLocalization();
        }
        return localiz;
    }

    public boolean getOpened() {
        return this.fOpened;
    }

    public void open() {
        this.fOpened = this.openHyperLink();
    }

    /*
     * WARNING - void declaration
     */
    public boolean openHyperLink() {
        IDocument doc;
        void tEditor;
        block15: {
            block14: {
                IEditorPart editor;
                String localiz = this.getLocalization();
                if (localiz == null) {
                    return false;
                }
                if (this.fBase.getUnderlyingResource() == null) {
                    return false;
                }
                if (this.fElement.length() == 0 || this.fElement.charAt(0) != '%') {
                    return false;
                }
                IProject proj = this.fBase.getUnderlyingResource().getProject();
                IFile file = proj.getFile(localiz + ".properties");
                if (!file.exists()) {
                    return false;
                }
                IEditorPart iEditorPart = editor = IDE.openEditor((IWorkbenchPage)PDEPlugin.getActivePage(), (IFile)file);
                if (iEditorPart instanceof TextEditor) {
                    TextEditor textEditor = (TextEditor)iEditorPart;
                    TextEditor cfr_ignored_0 = (TextEditor)iEditorPart;
                    break block14;
                }
                return false;
            }
            doc = tEditor.getDocumentProvider().getDocument((Object)tEditor.getEditorInput());
            if (doc != null) break block15;
            return false;
        }
        try {
            try {
                String key = this.fElement.substring(1);
                int keyLen = key.length();
                int length = doc.getLength();
                int start = 0;
                IRegion region = null;
                FindReplaceDocumentAdapter docSearch = new FindReplaceDocumentAdapter(doc);
                while ((region = docSearch.find(start, key, true, false, false, false)) != null) {
                    char c;
                    int offset = region.getOffset();
                    if (offset > 0 && (c = doc.getChar(offset - 1)) != '\n' && c != '\r') {
                        start += keyLen;
                        continue;
                    }
                    if (offset + keyLen < length && !Character.isWhitespace(c = doc.getChar(offset + keyLen)) && c != '=' && c != ':') {
                        start += keyLen;
                        continue;
                    }
                    tEditor.selectAndReveal(offset, keyLen);
                    break;
                }
            }
            catch (BadLocationException e) {
                PDEPlugin.log(e);
            }
        }
        catch (PartInitException partInitException) {
            return false;
        }
        return true;
    }
}

