/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.viewer;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.ui.views.features.model.IProductModelListener;
import org.eclipse.pde.internal.ui.views.features.model.ProductModelManager;
import org.eclipse.pde.internal.ui.views.features.support.FeaturesViewInput;
import org.eclipse.pde.internal.ui.views.features.viewer.DeferredFeaturesViewInput;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public abstract class AbstractFeatureTreeContentProvider
implements ITreeContentProvider,
IFeatureModelListener,
IProductModelListener {
    protected final FeatureModelManager fFeatureModelManager;
    protected final ProductModelManager fProductModelManager;
    protected DeferredFeaturesViewInput fInput;
    protected DeferredTreeContentManager fDeferredTreeContentManager;
    private TreeViewer fViewer;

    public AbstractFeatureTreeContentProvider(FeaturesViewInput featuresViewInput) {
        this.fFeatureModelManager = featuresViewInput.getFeatureSupport().getManager();
        this.fFeatureModelManager.addFeatureModelListener((IFeatureModelListener)this);
        this.fProductModelManager = featuresViewInput.getProductSupport().getManager();
        this.fProductModelManager.addProductModelListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
        this.fDeferredTreeContentManager = new DeferredTreeContentManager((AbstractTreeViewer)this.fViewer);
        this.fDeferredTreeContentManager.addUpdateCompleteListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                AbstractFeatureTreeContentProvider.this.resetViewerScrollPosition();
            }
        });
        if (newInput instanceof DeferredFeaturesViewInput) {
            this.fInput = (DeferredFeaturesViewInput)((Object)newInput);
        }
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getElements(Object inputElement) {
        Object object = inputElement;
        if (object instanceof DeferredFeaturesViewInput) {
            void deferredFeaturesViewInput;
            DeferredFeaturesViewInput deferredFeaturesViewInput2 = (DeferredFeaturesViewInput)((Object)object);
            DeferredFeaturesViewInput cfr_ignored_0 = (DeferredFeaturesViewInput)((Object)object);
            return deferredFeaturesViewInput.isInitialized() ? deferredFeaturesViewInput.getChildren(inputElement) : this.fDeferredTreeContentManager.getChildren(inputElement);
        }
        return new Object[0];
    }

    public void dispose() {
        this.fFeatureModelManager.removeFeatureModelListener((IFeatureModelListener)this);
        this.fProductModelManager.removeProductModelListener(this);
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.refreshViewer();
    }

    @Override
    public void modelsChanged() {
        this.refreshViewer();
    }

    private void refreshViewer() {
        this.runViewerTask(() -> ((TreeViewer)this.fViewer).refresh());
    }

    private void resetViewerScrollPosition() {
        this.runViewerTask(() -> {
            Tree tree = this.fViewer.getTree();
            if (tree.getItemCount() > 0) {
                TreeItem firstItem = tree.getItem(0);
                tree.setTopItem(firstItem);
            }
        });
    }

    private void runViewerTask(Runnable viewerTask) {
        if (this.fViewer.getTree().isDisposed()) {
            return;
        }
        this.fViewer.getTree().getDisplay().asyncExec(() -> {
            if (!this.fViewer.getTree().isDisposed()) {
                viewerTask.run();
            }
        });
    }
}

