/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.templates.PluginReference;

public class PluginClassCodeGenerator {
    private final PluginFieldData fPluginData;
    private final IProject fProject;
    private final String fQualifiedClassName;

    public PluginClassCodeGenerator(IProject project, String qualifiedClassName, PluginFieldData data, boolean generateTemplate) {
        this.fProject = project;
        this.fQualifiedClassName = qualifiedClassName;
        this.fPluginData = data;
    }

    public IFile generate(IProgressMonitor monitor) throws CoreException {
        int nameloc = this.fQualifiedClassName.lastIndexOf(46);
        String packageName = nameloc == -1 ? "" : this.fQualifiedClassName.substring(0, nameloc);
        String className = this.fQualifiedClassName.substring(nameloc + 1);
        IPath path = IPath.fromOSString((String)packageName.replace('.', '/'));
        if (this.fPluginData.getSourceFolderName().trim().length() > 0) {
            path = IPath.fromOSString((String)this.fPluginData.getSourceFolderName()).append(path);
        }
        CoreUtility.createFolder((IFolder)this.fProject.getFolder(path));
        IFile file = this.fProject.getFile(path.append(className + ".java"));
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        if (this.fPluginData.getOSGiFramework() != null || !this.fPluginData.isUIPlugin() || this.fPluginData.isE4Plugin()) {
            this.generateActivatorClass(packageName, className, writer);
        } else {
            this.generatePluginClass(packageName, className, writer);
        }
        writer.flush();
        try {
            swriter.close();
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes(this.fProject.getDefaultCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, true, monitor);
            } else {
                file.create((InputStream)stream, false, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    private void generatePluginClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        if (this.fPluginData.isUIPlugin()) {
            writer.println("import org.eclipse.ui.plugin.AbstractUIPlugin;");
        } else {
            writer.println("import org.eclipse.core.runtime.Plugin;");
        }
        writer.println("import org.osgi.framework.BundleContext;");
        writer.println();
        writer.println("/**");
        writer.println(" * The activator class controls the plug-in life cycle");
        writer.println(" */");
        if (this.fPluginData.isUIPlugin()) {
            writer.println("public class " + className + " extends AbstractUIPlugin {");
        } else {
            writer.println("public class " + className + " extends Plugin {");
        }
        writer.println();
        writer.println("\t// The plug-in ID");
        writer.println("\tpublic static final String PLUGIN_ID = \"" + this.fPluginData.getId() + "\"; //$NON-NLS-1$");
        writer.println();
        writer.println("\t// The shared instance");
        writer.println("\tprivate static " + className + " plugin;");
        writer.println("\t");
        writer.println("\t/**");
        writer.println("\t * The constructor");
        writer.println("\t */");
        writer.println("\tpublic " + className + "() {");
        writer.println("\t}");
        writer.println();
        writer.println("\t@Override");
        writer.println("\tpublic void start(BundleContext context) throws Exception {");
        writer.println("\t\tsuper.start(context);");
        writer.println("\t\tplugin = this;");
        writer.println("\t}");
        writer.println();
        writer.println("\t@Override");
        writer.println("\tpublic void stop(BundleContext context) throws Exception {");
        writer.println("\t\tplugin = null;");
        writer.println("\t\tsuper.stop(context);");
        writer.println("\t}");
        writer.println();
        writer.println("\t/**");
        writer.println("\t * Returns the shared instance");
        writer.println("\t *");
        writer.println("\t * @return the shared instance");
        writer.println("\t */");
        writer.println("\tpublic static " + className + " getDefault() {");
        writer.println("\t\treturn plugin;");
        writer.println("\t}");
        writer.println();
        writer.println("}");
    }

    private void generateActivatorClass(String packageName, String className, PrintWriter writer) {
        if (!packageName.equals("")) {
            writer.println("package " + packageName + ";");
            writer.println();
        }
        writer.println("import org.osgi.framework.BundleActivator;");
        writer.println("import org.osgi.framework.BundleContext;");
        writer.println();
        writer.println("public class " + className + " implements BundleActivator {");
        writer.println();
        writer.println("\tprivate static BundleContext context;");
        writer.println();
        writer.println("\tstatic BundleContext getContext() {");
        writer.println("\t\treturn context;");
        writer.println("\t}");
        writer.println();
        writer.println("\tpublic void start(BundleContext bundleContext) throws Exception {");
        writer.println("\t\t" + className + ".context = bundleContext;");
        writer.println("\t}");
        writer.println();
        writer.println("\tpublic void stop(BundleContext bundleContext) throws Exception {");
        writer.println("\t\t" + className + ".context = null;");
        writer.println("\t}");
        writer.println();
        writer.println("}");
    }

    public IPluginReference[] getDependencies() {
        ArrayList<PluginReference> result = new ArrayList<PluginReference>();
        if (this.fPluginData.isUIPlugin()) {
            result.add(new PluginReference("org.eclipse.ui"));
        }
        if (!this.fPluginData.isLegacy() && this.fPluginData.getOSGiFramework() == null) {
            result.add(new PluginReference("org.eclipse.core.runtime"));
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    public String[] getImportPackages() {
        String[] stringArray;
        if (this.fPluginData.getOSGiFramework() != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.osgi.framework;version=\"1.3.0\"";
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }
}

