/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.dialect;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.query.DRepresentationElementQuery;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.business.internal.dialect.description.TableInterpretedExpressionQuery;
import org.eclipse.sirius.table.business.internal.refresh.DTableElementSynchronizer;
import org.eclipse.sirius.table.business.internal.refresh.DTableSynchronizerImpl;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.tools.internal.Messages;
import org.eclipse.sirius.table.tools.internal.command.TableCommandFactory;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TableDialectServices
extends AbstractRepresentationDialectServices {
    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DTable;
    }

    protected boolean isSupported(DRepresentationDescriptor representationDescriptor) {
        return representationDescriptor.getDescription() instanceof TableDescription;
    }

    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof TableDescription;
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc, boolean checkSelectedViewpoint) {
        Session session;
        boolean result = false;
        if (semantic != null && this.isSupported(desc) && ((session = new EObjectQuery(semantic).getSession()) == null || checkSelectedViewpoint && this.isRelatedViewpointSelected(session, desc) || !checkSelectedViewpoint)) {
            TableDescription tableDesc = (TableDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, tableDesc.getDomainClass());
            }
            result = result && this.checkPrecondition(semantic, tableDesc.getPreconditionExpression());
        }
        return result;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DTable table = null;
        try {
            monitor.beginTask(MessageFormat.format(Messages.TableDialectServices_CreateTable, name), 11);
            monitor.subTask(MessageFormat.format(Messages.TableDialectServices_CreateTable, name));
            table = TableFactory.eINSTANCE.createDTable();
            table.setTarget(semantic);
            table.setDescription((TableDescription)description);
            monitor.worked(1);
            this.refresh((DRepresentation)table, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
        return table;
    }

    public void refresh(DRepresentation representation, boolean fullRefresh, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.TableDialectServices_RefreshTable, 1);
            DTable table = (DTable)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(table.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            TableDescription description = table.getDescription();
            DTableSynchronizerImpl sync = new DTableSynchronizerImpl(description, accessor, interpreter);
            sync.setTable(table);
            sync.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void refreshImpactedElements(DRepresentation representation, Collection<Notification> notifications, IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.TableDialectServices_RefreshTable, 10);
            DTable table = (DTable)representation;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(table.getTarget());
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)representation);
            Set<DTableElement> dTableElements = this.getTableElementsToRefresh(notifications, table);
            monitor.worked(2);
            DTableElementSynchronizer synchronizer = new DTableElementSynchronizer(accessor, interpreter);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 8);
            try {
                subMonitor.beginTask(Messages.TableDialectServices_RefreshImpactedElements, dTableElements.size());
                for (DTableElement dTableElement : dTableElements) {
                    if (dTableElement instanceof DCell) {
                        synchronizer.refresh((DCell)dTableElement);
                    } else if (dTableElement instanceof DLine) {
                        synchronizer.refresh((DLine)dTableElement);
                        synchronizer.refreshSemanticElements(dTableElement, (TableMapping)((DLine)dTableElement).getOriginMapping());
                    } else if (dTableElement instanceof DColumn) {
                        synchronizer.refresh((DColumn)dTableElement);
                        synchronizer.refreshSemanticElements(dTableElement, (TableMapping)((DColumn)dTableElement).getOriginMapping());
                    }
                    subMonitor.worked(1);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private Set<DTableElement> getTableElementsToRefresh(Collection<Notification> notifications, DTable table) {
        HashSet<DTableElement> tableElementsToRefresh = new HashSet<DTableElement>();
        Session session = new EObjectQuery(table.getTarget()).getSession();
        if (session != null) {
            ECrossReferenceAdapter xref = session.getSemanticCrossReferencer();
            HashSet<EObject> alreadyDoneNotifiers = new HashSet<EObject>();
            for (Notification notification : notifications) {
                EObject eObjectNotifier;
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject) || !alreadyDoneNotifiers.add(eObjectNotifier = (EObject)notifier)) continue;
                tableElementsToRefresh.addAll(this.getTableElementsToRefresh(eObjectNotifier, table, xref));
            }
        }
        return tableElementsToRefresh;
    }

    private Set<DTableElement> getTableElementsToRefresh(EObject notifier, DTable table, ECrossReferenceAdapter xref) {
        HashSet<DTableElement> tableElementsToRefresh = new HashSet<DTableElement>();
        Collection inverseReferencers = new EObjectQuery(notifier, xref).getInverseReferences(REPRESENTATION_ELEMENTS_INVERSE_REFERENCES);
        for (EObject inverseReferencer : inverseReferencers) {
            DTableElement tableElement;
            if (!(inverseReferencer instanceof DTableElement) || !this.isContainedWithinCurrentTable(tableElement = (DTableElement)inverseReferencer, table)) continue;
            tableElementsToRefresh.add(tableElement);
        }
        return tableElementsToRefresh;
    }

    private boolean isContainedWithinCurrentTable(DTableElement tableElement, DTable table) {
        return table == new DRepresentationElementQuery((DRepresentationElement)tableElement).getParentRepresentation();
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (this.isSupported(representation)) {
            return ((DTable)representation).getDescription();
        }
        return null;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, TableDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TableDescription tableDescription;
        if (representationDescription instanceof TableDescription && this.shouldInitializeRepresentation(semanticElement, (RepresentationDescription)(tableDescription = (TableDescription)representationDescription), tableDescription.getDomainClass())) {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)semanticElement);
            if (modelAccessor.eInstanceOf(semanticElement, tableDescription.getDomainClass())) {
                boolean canCreate = true;
                if (tableDescription.getPreconditionExpression() != null && !StringUtil.isEmpty((String)tableDescription.getPreconditionExpression())) {
                    try {
                        canCreate = InterpreterUtil.getInterpreter((EObject)semanticElement).evaluateBoolean(semanticElement, tableDescription.getPreconditionExpression());
                    }
                    catch (EvaluationException evaluationException) {
                        canCreate = false;
                    }
                }
                if (canCreate) {
                    try {
                        monitor.beginTask(MessageFormat.format(Messages.TableDialectServices_InitializeTable, new IdentifiedElementQuery(representationDescription).getLabel()), 1);
                        TableCommandFactory tableCommandFactory = new TableCommandFactory(domain);
                        tableCommandFactory.setModelAccessor(modelAccessor);
                        DCommand command = tableCommandFactory.buildCreateTableFromDescription(tableDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        domain.getCommandStack().execute((Command)command);
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new TableInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof TableDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return false;
    }
}

