/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

class FreeformHelper
implements FreeformListener {
    private final FreeformFigure host;
    private Rectangle freeformExtent;
    private final FigureListener figureListener = new ChildTracker();

    FreeformHelper(FreeformFigure host) {
        this.host = host;
    }

    /*
     * WARNING - void declaration
     */
    public Rectangle getFreeformExtent() {
        if (this.freeformExtent != null) {
            return this.freeformExtent;
        }
        for (IFigure iFigure : this.host.getChildren()) {
            Rectangle r;
            IFigure iFigure2 = iFigure;
            if (iFigure2 instanceof FreeformFigure) {
                void freeFormFig;
                FreeformFigure cfr_ignored_0 = (FreeformFigure)iFigure2;
                FreeformFigure cfr_ignored_1 = (FreeformFigure)iFigure2;
                r = freeFormFig.getFreeformExtent();
            } else {
                r = iFigure.getBounds();
            }
            if (this.freeformExtent == null) {
                this.freeformExtent = r.getCopy();
                continue;
            }
            this.freeformExtent.union(r);
        }
        Insets insets = this.host.getInsets();
        if (this.freeformExtent == null) {
            this.freeformExtent = new Rectangle(0, 0, insets.getWidth(), insets.getHeight());
        } else {
            this.host.translateToParent(this.freeformExtent);
            this.freeformExtent.expand(insets);
        }
        return this.freeformExtent;
    }

    /*
     * WARNING - void declaration
     */
    public void hookChild(IFigure child) {
        this.invalidate();
        IFigure iFigure = child;
        if (iFigure instanceof FreeformFigure) {
            void freeFormFig;
            FreeformFigure freeformFigure = (FreeformFigure)iFigure;
            FreeformFigure cfr_ignored_0 = (FreeformFigure)iFigure;
            freeFormFig.addFreeformListener(this);
        } else {
            child.addFigureListener(this.figureListener);
        }
    }

    void invalidate() {
        this.freeformExtent = null;
        this.host.fireExtentChanged();
        if (this.host.getParent() != null) {
            this.host.getParent().revalidate();
        } else {
            this.host.revalidate();
        }
    }

    @Override
    public void notifyFreeformExtentChanged() {
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFreeformBounds(Rectangle bounds) {
        this.host.setBounds(bounds);
        bounds = bounds.getCopy();
        this.host.translateFromParent(bounds);
        for (IFigure iFigure : this.host.getChildren()) {
            void freeFormFig;
            IFigure iFigure2 = iFigure;
            if (!(iFigure2 instanceof FreeformFigure)) continue;
            FreeformFigure cfr_ignored_0 = (FreeformFigure)iFigure2;
            FreeformFigure cfr_ignored_1 = (FreeformFigure)iFigure2;
            freeFormFig.setFreeformBounds(bounds);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unhookChild(IFigure child) {
        this.invalidate();
        IFigure iFigure = child;
        if (iFigure instanceof FreeformFigure) {
            void freeFormFig;
            FreeformFigure freeformFigure = (FreeformFigure)iFigure;
            FreeformFigure cfr_ignored_0 = (FreeformFigure)iFigure;
            freeFormFig.removeFreeformListener(this);
        } else {
            child.removeFigureListener(this.figureListener);
        }
    }

    class ChildTracker
    implements FigureListener {
        ChildTracker() {
        }

        @Override
        public void figureMoved(IFigure source) {
            FreeformHelper.this.invalidate();
        }
    }
}

