/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.editors;

import org.eclipse.fx.ide.fxml.editors.FXMLCompletionProposalComputer;
import org.eclipse.fx.ide.fxml.editors.Util;
import org.eclipse.fx.ide.model.FXPlugin;
import org.eclipse.fx.ide.model.IFXClass;
import org.eclipse.fx.ide.model.IFXCtrlClass;
import org.eclipse.fx.ide.model.IFXCtrlEventMethod;
import org.eclipse.fx.ide.model.IFXEnumProperty;
import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.IFXProperty;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FXMLTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private FXMLCompletionProposalComputer.JavadocHoverWrapper javadocWrapper = new FXMLCompletionProposalComputer.JavadocHoverWrapper();
    private IJavaElement element;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object o = this.getHoverInfo2(textViewer, hoverRegion);
        return o != null ? o.toString() : null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        String regionType;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(offset)) != null && ((regionType = region.getType()) == "XML_TAG_NAME" || regionType == "XML_TAG_ATTRIBUTE_NAME" || regionType == "XML_TAG_ATTRIBUTE_VALUE" || regionType == "XML_PI_CONTENT")) {
            try {
                IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
                if (offset > line.getOffset() && offset < line.getOffset() + line.getLength() && offset < flatNode.getTextEndOffset(region)) {
                    return new Region(flatNode.getStartOffset(region), region.getTextLength());
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
        return null;
    }

    static IJavaElement computeTagNameHelp(IDOMNode xmlnode) {
        if (Character.isLowerCase(xmlnode.getNodeName().charAt(0))) {
            IFXProperty p;
            IFXClass fxClass;
            Node parent = xmlnode.getParentNode();
            if (parent == null || parent.getNodeName() == null || parent.getOwnerDocument() == null) {
                return null;
            }
            IType ownerType = Util.findType(parent.getNodeName(), parent.getOwnerDocument());
            if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null && (p = fxClass.getProperty(xmlnode.getNodeName())) != null) {
                return p.getJavaElement();
            }
        } else if (xmlnode.getNodeName().contains(".")) {
            IFXProperty p;
            IFXClass fxClass;
            String[] parts = xmlnode.getNodeName().split("\\.");
            IType ownerType = Util.findType(parts[0], xmlnode.getOwnerDocument());
            if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null && (p = fxClass.getStaticProperty(parts[1])) != null) {
                return p.getJavaElement();
            }
        } else {
            IFXClass fxClass;
            IType ownerType = Util.findType(xmlnode.getNodeName(), xmlnode.getOwnerDocument());
            if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null) {
                try {
                    return Util.findProject(xmlnode.getOwnerDocument()).findType(fxClass.getFQN());
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    static IJavaElement computeTagAttNameHelp(IDOMNode xmlnode, int offset) {
        NamedNodeMap m = xmlnode.getAttributes();
        IDOMNode attribute = null;
        if (m != null) {
            int i = 0;
            while (i < m.getLength()) {
                IDOMNode a = (IDOMNode)m.item(i);
                if (a.contains(offset)) {
                    attribute = a;
                }
                ++i;
            }
        }
        if (attribute != null) {
            IDOMNode parent = xmlnode;
            if (attribute.getNodeName().contains(".")) {
                IFXProperty p;
                IFXClass fxClass;
                String[] parts = attribute.getNodeName().split("\\.");
                IType ownerType = Util.findType(parts[0], parent.getOwnerDocument());
                if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null && (p = fxClass.getStaticProperty(parts[1])) != null) {
                    return p.getJavaElement();
                }
            } else {
                IFXProperty p;
                IFXClass fxClass;
                IType ownerType = Util.findType(parent.getNodeName(), parent.getOwnerDocument());
                if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null && (p = fxClass.getProperty(attribute.getNodeName())) != null) {
                    return p.getJavaElement();
                }
            }
        }
        return null;
    }

    static IJavaElement computeTagAttValueHelp(IDOMNode xmlnode, int offset) {
        NamedNodeMap m = xmlnode.getAttributes();
        IDOMNode attribute = null;
        if (m == null) {
            return null;
        }
        int i = 0;
        while (i < m.getLength()) {
            IDOMNode a = (IDOMNode)m.item(i);
            if (a.contains(offset)) {
                attribute = a;
            }
            ++i;
        }
        if (attribute != null) {
            IFXCtrlClass cl;
            IFXCtrlEventMethod method;
            IType t;
            Document d;
            Element e;
            Attr a;
            IDOMNode parent = xmlnode;
            IFXProperty p = null;
            if ("http://javafx.com/fxml".equals(attribute.getNamespaceURI())) {
                Document d2 = xmlnode.getOwnerDocument();
                return Util.findType(attribute.getNodeValue(), d2);
            }
            if (attribute.getNodeName().contains(".")) {
                IFXClass fxClass;
                String[] parts = attribute.getNodeName().split("\\.");
                IType ownerType = Util.findType(parts[0], parent.getOwnerDocument());
                if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null) {
                    p = fxClass.getStaticProperty(parts[1]);
                }
            } else {
                IFXClass fxClass;
                IType ownerType = Util.findType(parent.getNodeName(), parent.getOwnerDocument());
                if (ownerType != null && (fxClass = FXPlugin.getClassmodel().findClass(ownerType.getJavaProject(), ownerType)) != null) {
                    p = fxClass.getProperty(attribute.getNodeName());
                }
            }
            if (p instanceof IFXEnumProperty) {
                IType t2 = ((IFXEnumProperty)p).getEnumType();
                try {
                    IField[] iFieldArray = t2.getFields();
                    int n = iFieldArray.length;
                    int fxClass = 0;
                    while (fxClass < n) {
                        IField f = iFieldArray[fxClass];
                        if (Flags.isEnum((int)f.getFlags()) && f.getElementName().equals(attribute.getNodeValue())) {
                            return f;
                        }
                        ++fxClass;
                    }
                }
                catch (JavaModelException e2) {
                    e2.printStackTrace();
                }
            } else if (p instanceof IFXEventHandlerProperty && attribute.getNodeValue().startsWith("#") && (a = (e = (d = xmlnode.getOwnerDocument()).getDocumentElement()).getAttributeNodeNS("http://javafx.com/fxml", "controller")) != null && (t = Util.findType(a.getValue(), d)) != null && (method = (IFXCtrlEventMethod)(cl = FXPlugin.getClassmodel().findCtrlClass(t.getJavaProject(), t)).getAllEventMethods().get(attribute.getNodeValue().substring(1))) != null) {
                return method.getJavaElement();
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.element != null) {
            this.javadocWrapper.setJavaElement(this.element);
            return this.javadocWrapper.getHoverControlCreator();
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        ITextRegion region;
        if (hoverRegion == null || textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        this.element = null;
        int documentOffset = hoverRegion.getOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentOffset);
        if (treeNode == null) {
            return null;
        }
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(documentOffset);
        if (flatNode != null && (region = flatNode.getRegionAtCharacterOffset(documentOffset)) != null) {
            String regionType = region.getType();
            if (regionType == "XML_TAG_NAME") {
                this.element = FXMLTextHover.computeTagNameHelp((IDOMNode)treeNode);
            } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                IDOMNode dom = (IDOMNode)treeNode;
                if (dom instanceof ProcessingInstruction) {
                    String fqn = dom.getNodeValue();
                    if (fqn.endsWith("?")) {
                        fqn = fqn.substring(0, fqn.length() - 1);
                    }
                    this.element = Util.findType(fqn, dom.getOwnerDocument());
                } else {
                    this.element = FXMLTextHover.computeTagAttNameHelp((IDOMNode)treeNode, documentOffset);
                }
            } else if (regionType == "XML_PI_CONTENT") {
                IDOMNode dom = (IDOMNode)treeNode;
                String fqn = dom.getNodeValue();
                if (fqn.endsWith("?")) {
                    fqn = fqn.substring(0, fqn.length() - 1);
                }
                if (!(fqn.endsWith(".css") || fqn.endsWith(".properties") || fqn.endsWith("*"))) {
                    this.element = Util.findType(fqn, dom.getOwnerDocument());
                }
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                this.element = FXMLTextHover.computeTagAttValueHelp((IDOMNode)treeNode, documentOffset);
            }
        }
        if (this.element != null) {
            this.javadocWrapper.setJavaElement(this.element);
            return this.javadocWrapper.getHoverInfo2(textViewer, hoverRegion);
        }
        return null;
    }
}

