/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.list;

import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.StringProperty;
import javafx.scene.control.ListCell;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.TextRegistry;
import org.eclipse.jdt.annotation.Nullable;

public class L10NListCell<T>
extends ListCell<T> {
    private final TextRegistry textRegistry;
    private final Function<@Nullable T, @Nullable String> registryComputer;
    private Subscription subscription;

    public L10NListCell(TextRegistry textRegistry, Function<@Nullable T, @Nullable String> registryComputer) {
        this.textRegistry = textRegistry;
        this.registryComputer = registryComputer;
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (this.subscription != null) {
            this.subscription.dispose();
        }
        if (!empty) {
            String key = this.registryComputer.apply(item);
            if (key != null) {
                Supplier supplier = null;
                try {
                    supplier = this.textRegistry.getSupplierByKey(key, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (supplier != null) {
                    this.subscription = this.textRegistry.register(arg_0 -> ((StringProperty)this.textProperty()).set(arg_0), supplier);
                } else {
                    this.setText("Unknown l10n key '" + key + "'");
                }
            } else {
                this.setText("");
            }
        } else {
            this.setText("");
        }
    }
}

