/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.model.editor.dialogs.EGFWizardDialog;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.editor.wizards.InvokeActivityWizard;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;

public class InvokeActivityMenuContributor
extends EditorMenuContributor {
    public static final String INVOKE_ACTIVITY_ACTION_ID = "invoke-activity";
    private final InvokeActivityAction _invokeActivityAction = new InvokeActivityAction();

    public void menuAboutToShow(IMenuManager menuManager) {
        IStructuredSelection selection2 = (IStructuredSelection)this._selection;
        if (selection2.size() == 1 && selection2.getFirstElement() instanceof ProductionPlan) {
            this._invokeActivityAction.setEnabled(this._invokeActivityAction.isEnabled());
            menuManager.insertBefore("open", (IAction)this._invokeActivityAction);
        }
    }

    protected class InvokeActivityAction
    extends Action {
        public InvokeActivityAction() {
            super(ModelEditorMessages.ActivityMenuContributor_invokeAction_label);
            this.setId(InvokeActivityMenuContributor.INVOKE_ACTIVITY_ACTION_ID);
        }

        public boolean isEnabled() {
            ProductionPlan eObject = this.getProductionPlan();
            if (eObject == null) {
                return false;
            }
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            if (eObject.eResource() == null || domain == null) {
                return false;
            }
            return !domain.isReadOnly(eObject.eResource());
        }

        protected ProductionPlan getProductionPlan() {
            if (InvokeActivityMenuContributor.this._selection == null) {
                return null;
            }
            IStructuredSelection sselection = (IStructuredSelection)InvokeActivityMenuContributor.this._selection;
            if (sselection.size() != 1) {
                return null;
            }
            Object object = sselection.getFirstElement();
            if (object instanceof ProductionPlan) {
                return (ProductionPlan)object;
            }
            return null;
        }

        public void run() {
            ProductionPlan productionPlan = this.getProductionPlan();
            if (productionPlan == null) {
                return;
            }
            InvokeActivityWizard wizard = new InvokeActivityWizard();
            wizard.init(InvokeActivityMenuContributor.this._activeEditorPart.getSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)InvokeActivityMenuContributor.this._selection);
            EGFWizardDialog dialog = new EGFWizardDialog(InvokeActivityMenuContributor.this._activeEditorPart.getSite().getShell(), (IWizard)wizard);
            dialog.create();
            dialog.open();
        }
    }
}

