/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.Map;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.ui.dialogs.PlatformPackageDialog;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LoadEcoreDialog
extends LoadResourceAction.LoadResourceDialog {
    private boolean _asEPackageNsURI;

    public LoadEcoreDialog(Shell parent, EditingDomain domain) {
        this(parent, domain, false);
    }

    public LoadEcoreDialog(Shell parent, EditingDomain domain, boolean asEPackageNsURI) {
        super(parent, domain);
        this._asEPackageNsURI = asEPackageNsURI;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite buttonComposite = (Composite)composite.getChildren()[0];
        Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
        browseRegisteredPackagesButton.setText(CoreUIMessages._UI_BrowseRegisteredPackages_label);
        this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
        FormData data = new FormData();
        Control[] children = buttonComposite.getChildren();
        data.right = new FormAttachment(children[0], -10);
        browseRegisteredPackagesButton.setLayoutData((Object)data);
        return composite;
    }

    protected void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
        browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformPackageDialog dialog = new PlatformPackageDialog(LoadEcoreDialog.this.getShell());
                if (dialog.open() != 0) {
                    return;
                }
                Object[] result = dialog.getResult();
                if (result == null) {
                    return;
                }
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.setURIConverter((URIConverter)EGFCorePlugin.getPlatformURIConverter());
                StringBuffer uris = new StringBuffer();
                if (dialog.isTarget() && !LoadEcoreDialog.this._asEPackageNsURI) {
                    Map ePackageNsURItoGenModelLocationMap = EGFCorePlugin.getEPackageNsURIToGenModelLocationMap();
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        IPlatformGenModel genmodel = (IPlatformGenModel)result[i];
                        if (genmodel.getURI() != null) {
                            URI location = (URI)ePackageNsURItoGenModelLocationMap.get(genmodel.getURI().toString());
                            Resource resource = resourceSet.getResource(location, true);
                            EcoreUtil.resolveAll((Resource)resource);
                        }
                        ++i;
                    }
                    for (Resource resource : resourceSet.getResources()) {
                        block2: for (EPackage ePackage : EMFHelper.getAllPackages((Resource)resource)) {
                            int i2 = 0;
                            int length2 = result.length;
                            while (i2 < length2) {
                                if (((IPlatformGenModel)result[i2]).getId().compareTo(ePackage.getNsURI()) == 0) {
                                    URI resourceUri = resource.getURI();
                                    uris.append(resourceUri);
                                    uris.append("  ");
                                    continue block2;
                                }
                                ++i2;
                            }
                        }
                    }
                    LoadEcoreDialog.this.uriField.setText("");
                    LoadEcoreDialog.this.uriField.setText((String.valueOf(LoadEcoreDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                } else {
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        uris.append(result[i]);
                        uris.append("  ");
                        ++i;
                    }
                    LoadEcoreDialog.this.uriField.setText("");
                    LoadEcoreDialog.this.uriField.setText((String.valueOf(LoadEcoreDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }
            }
        });
    }
}

