/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.query.QueryKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IQuery {
    public static final Helper INSTANCE = new Helper();

    public List<Object> execute(ParameterDescription var1, Map<String, String> var2, PatternContext var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Helper {
        public IQuery loadQuery(String id) {
            QueryKind queryKind = this.getQueryKind(id);
            if (queryKind == null) {
                throw new IllegalStateException(Messages.query_error6);
            }
            return null;
        }

        public QueryKind getQueryKindByName(String name) {
            for (QueryKind queryKind : this.getAvailableQueries()) {
                if (!name.equals(queryKind.getName())) continue;
                return queryKind;
            }
            return null;
        }

        public QueryKind getQueryKind(String id) {
            for (QueryKind queryKind : this.getAvailableQueries()) {
                if (!id.equals(queryKind.getId())) continue;
                return queryKind;
            }
            return null;
        }

        public List<QueryKind> getAvailableQueries() {
            ArrayList<QueryKind> queries = new ArrayList<QueryKind>(50);
            QueryKind[] queryKindArray = (QueryKind[])EGFPlatformPlugin.getPlatformManager().getPlatformExtensionPoints(QueryKind.class);
            int n = queryKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                QueryKind kind = queryKindArray[n2];
                queries.add(kind);
                ++n2;
            }
            return queries;
        }

        public String getQueryClassName(String queryID) throws PatternException {
            if (queryID == null || "".equals(queryID)) {
                throw new PatternException(Messages.query_error2);
            }
            QueryKind[] queryKindArray = (QueryKind[])EGFPlatformPlugin.getPlatformManager().getPlatformExtensionPoints(QueryKind.class);
            int n = queryKindArray.length;
            int n2 = 0;
            while (n2 < n) {
                QueryKind kind = queryKindArray[n2];
                if (queryID.equals(kind.getId())) {
                    if (kind.getClassName() == null || "".equals(kind.getClassName())) {
                        throw new PatternException(Messages.query_error5);
                    }
                    return kind.getClassName();
                }
                ++n2;
            }
            throw new PatternException(Messages.bind((String)Messages.query_error3, (Object)queryID));
        }

        private Helper() {
        }
    }

    public static class ParameterDescription {
        private String name;
        private String type;

        public ParameterDescription(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

