/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.query;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.egf.core.platform.pde.PlatformExtensionPointURI;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactory
implements IPlatformExtensionPointFactory<QueryKind> {
    private static final String ID_ATTR = "id";
    private static final String CLASS_ATTR = "class";
    private static final String NAME_ATTR = "name";

    public QueryKind createExtensionPoint(IPlatformBundle platformBundle, IPluginElement pluginElement) {
        if (pluginElement == null) {
            return null;
        }
        IPluginAttribute id = pluginElement.getAttribute(ID_ATTR);
        if (id == null || id.getValue() == null || id.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute className = pluginElement.getAttribute(CLASS_ATTR);
        if (className == null || className.getValue() == null || className.getValue().trim().length() == 0) {
            return null;
        }
        IPluginAttribute name = pluginElement.getAttribute(NAME_ATTR);
        if (name == null || name.getValue() == null || name.getValue().trim().length() == 0) {
            return null;
        }
        return new QueryKindImpl(platformBundle, id.getValue(), className.getValue(), name.getValue());
    }

    private static class QueryKindImpl
    extends PlatformExtensionPointURI
    implements QueryKind {
        private final String className;
        private final String name;

        public QueryKindImpl(IPlatformBundle bundle, String id, String className, String name) {
            super(bundle, id);
            Assert.isNotNull((Object)className);
            Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
            Assert.isNotNull((Object)name);
            Assert.isLegal((name.trim().length() != 0 ? 1 : 0) != 0);
            this.className = className.trim();
            this.name = name.trim();
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof QueryKind)) {
                return false;
            }
            QueryKind queryKind = (QueryKind)object;
            if (!queryKind.getClassName().equals(this.getClassName())) {
                return false;
            }
            return queryKind.getName().equals(this.getName());
        }
    }
}

