/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.strategy;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.egf.model.pattern.util.PatternSwitch;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.strategy.AbstractPatternStrategy;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterStrategy
extends AbstractPatternStrategy {
    private static final String OK = "ok";

    @Override
    public void execute(PatternContext context, Object parameter) throws PatternException, ExtensionHelper.MissingExtensionException {
        if (parameter == null) {
            throw new PatternException(Messages.strategy_error3);
        }
        if (!(parameter instanceof String)) {
            throw new PatternException(Messages.bind((String)Messages.strategy_error2, (Object)"String", (Object)parameter.getClass().getName()));
        }
        String filter = (String)parameter;
        TypePatternSubstitution substitutions = (TypePatternSubstitution)context.getValue("pattern.substitutions");
        List<Pattern> patterns = this.getPatterns(filter, substitutions);
        this.doExecute(patterns, context);
    }

    protected List<Pattern> getPatterns(String filter, TypePatternSubstitution substitutions) throws PatternException {
        PatternElement[] elements = this.patternElements;
        LinkedHashSet result = new LinkedHashSet(elements.length * 2);
        FilterSwitch switch_ = new FilterSwitch(filter, result, substitutions);
        PatternElement[] patternElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            PatternElement elem = patternElementArray[n2];
            String error = (String)switch_.doSwitch((EObject)elem);
            if (error != null && !OK.equals(error)) {
                throw new PatternException(error);
            }
            ++n2;
        }
        return new ArrayList<Pattern>(result);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterSwitch
    extends PatternSwitch<String> {
        private final String filter;
        private final Set<Pattern> result;
        private final TypePatternSubstitution substitutions;

        private FilterSwitch(String filter, Set<Pattern> result, TypePatternSubstitution substitutions) {
            this.filter = filter;
            this.result = result;
            this.substitutions = substitutions;
        }

        public String casePattern(Pattern object) {
            this.result.add(object);
            return FilterStrategy.OK;
        }

        public String casePatternLibrary(PatternLibrary object) {
            EList list = (EList)object.getFilters().get((Object)this.filter);
            if (list != null) {
                for (PatternElement elem : list) {
                    String error = (String)this.doSwitch((EObject)elem);
                    if (error == null || FilterStrategy.OK.equals(error)) continue;
                    return error;
                }
            }
            return FilterStrategy.OK;
        }

        public String defaultCase(EObject object) {
            return Messages.bind((String)Messages.strategy_error1, (Object)object);
        }
    }
}

