/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.emf.common.util.URI;

public class FileHelper {
    public static void setContent(IFile file, String source) throws CoreException {
        FileHelper.setContent(file, source, true);
    }

    public static void setContent(IFile file, String source, boolean keepHistory) throws CoreException {
        FileHelper.setContent(file, new ByteArrayInputStream(source.getBytes()), keepHistory);
    }

    private static void setContent(IFile file, InputStream source, boolean keepHistory) throws CoreException {
        if (file.exists()) {
            file.setContents(source, true, keepHistory, null);
        } else {
            FileHelper.createParentfolders(file.getProject(), file.getProjectRelativePath().removeLastSegments(1));
            file.create(source, true, null);
        }
    }

    private static void createParentfolders(IProject project, IPath folderPath) throws CoreException {
        if (folderPath.isEmpty()) {
            return;
        }
        IFolder folder = project.getFolder(folderPath);
        if (folder == null) {
            throw new IllegalStateException();
        }
        if (!folder.exists()) {
            FileHelper.createParentfolders(project, folderPath.removeLastSegments(1));
            folder.create(true, true, null);
        }
    }

    public static String getContent(String pluginId, IProject project, IPath templatePath) throws CoreException, IOException {
        IFile file = project.getFile(templatePath);
        if (file == null) {
            throw new IllegalStateException();
        }
        if (file.exists()) {
            return FileHelper.getFileContent(file);
        }
        URI uri = URIHelper.getPlatformPluginURI((String)pluginId, (String)templatePath.toPortableString(), (boolean)false);
        return FileHelper.getContent(EGFCorePlugin.getPlatformURIConverter().createInputStream(uri));
    }

    public static String getContent(IPlatformFcore component, URI uri) throws IOException {
        if (component == null) {
            throw new IllegalArgumentException(Messages.fileHelper_error3);
        }
        if (uri.isRelative()) {
            uri = URI.createURI((String)(String.valueOf(component.getPlatformBundle().getUnrootedBase().toString()) + "/" + uri.toString()));
        }
        return FileHelper.getContent(EGFCorePlugin.getPlatformURIConverter().createInputStream(uri));
    }

    public static String getFileContent(IFile file) throws CoreException, IOException {
        return FileHelper.getContent(file.getContents());
    }

    private static String getContent(InputStream contents) throws IOException {
        byte[] buf = null;
        try {
            buf = new byte[contents.available()];
            contents.read(buf);
        }
        finally {
            if (contents != null) {
                contents.close();
            }
        }
        return new String(buf);
    }
}

