/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.application.activity;

import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.application.activity.IApplicationConfigurationConstants;
import org.eclipse.egf.application.internal.activator.EGFApplicationPlugin;
import org.eclipse.egf.application.internal.activity.ActivityRunner;
import org.eclipse.egf.application.internal.l10n.ApplicationMessages;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityApplication
implements IApplication {
    public Object run(Object object) throws Exception {
        if (object == null || !(object instanceof String[]) || ((String[])object).length < 2 || !"-activities".equals(((String[])object)[0])) {
            System.err.println(ApplicationMessages.ActivityApplication_Arguments_Usage);
            return IApplicationConfigurationConstants.EXIT_ERROR;
        }
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        UniqueEList activities = new UniqueEList();
        int i = 1;
        while (i < ((String[])object).length) {
            block10: {
                String activity = ((String[])object)[i];
                if (activity != null) {
                    URI uri = null;
                    try {
                        uri = URI.createURI((String)activity);
                    }
                    catch (Throwable t) {
                        EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_Invalid_URI_Argument, (Object)i, (Object)activity), t)));
                        break block10;
                    }
                    EObject eObject = null;
                    try {
                        eObject = editingDomain.getResourceSet().getEObject(uri, true);
                    }
                    catch (Throwable t) {
                        EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_EObject_Loading_Error, (Object)i, (Object)uri.toString()), t)));
                        break block10;
                    }
                    if (eObject == null || !(eObject instanceof Activity)) {
                        EGFApplicationPlugin.getDefault().logError((Throwable)new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityApplication_Invalid_Activity_Argument, (Object)i, (Object)uri.toString()), null)));
                    } else {
                        activities.add((Activity)eObject);
                    }
                }
            }
            ++i;
        }
        if (activities.isEmpty()) {
            return IApplication.EXIT_OK;
        }
        return ActivityApplication.runHelper((List<Activity>)activities);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args == null || args.length < 2 || !"-activities".equals(args[0])) {
            System.err.println(ApplicationMessages.ActivityApplication_Arguments_Usage);
            return IApplicationConfigurationConstants.EXIT_ERROR;
        }
        return this.run(args);
    }

    public void stop() {
    }

    public static Object runHelper(final List<Activity> activities) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ActivityRunner runner = new ActivityRunner(activities);
                    runner.run(monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.EclipseUtil.StreamProgressMonitor(System.out));
        return IApplication.EXIT_OK;
    }
}

