/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.contentassist;

import java.util.HashMap;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.contentassist.AbstractJETAssistProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class JETJavaExpressionAssistProcessor
extends AbstractJETAssistProcessor {
    private char[] completionProposalAutoActivationCharacters;

    public JETJavaExpressionAssistProcessor(JETTextEditor editor) {
        super(editor);
        this.completionProposalAutoActivationCharacters = editor.getEditorPreferenceStore().getString("content_assist_autoactivation_triggers_java").toCharArray();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        JETCompilationUnit cu = this.editor.requestCompilationUnit();
        JavaExpression expression = (JavaExpression)this.editor.getASTElement(offset);
        int javaContentStart = expression.getJavaStart();
        IJavaProject javaProject = this.editor.getJavaProject();
        if (javaProject != null) {
            HashMap mappingPositions = new HashMap();
            String javaSource = this.editor.compilationHelper().getJavaCode(cu, mappingPositions);
            int javaStartOffset = ((Position)mappingPositions.get((Object)expression)).offset;
            JETEditorHelper.checkOffsetPositions(javaSource, viewer.getDocument().get(), javaContentStart, javaStartOffset, expression.getJavaEnd() - javaContentStart);
            int javaCursorOffset = javaStartOffset + (offset - javaContentStart);
            IJavaCompletionProposal[] javaCompletionProposals = JETEditorHelper.getJavaCompletionProposal(javaProject, cu, javaSource, viewer, javaCursorOffset);
            JETEditorHelper.adjustResults(javaCompletionProposals, offset);
            return javaCompletionProposals;
        }
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

