/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.modifiers;

import org.eclipse.egf.model.pattern.BasicQuery;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.editors.modifiers.EditingDomainCellModifier;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class ParametersTableCellModifier
extends EditingDomainCellModifier {
    public ParametersTableCellModifier(TransactionalEditingDomain editingDomain, TableViewer tableViewer) {
        super(editingDomain, tableViewer);
    }

    public boolean canModify(Object element, String property) {
        if ("Name".equals(property)) {
            return true;
        }
        if ("Type".equals(property)) {
            return true;
        }
        return "Query".equals(property);
    }

    public Object getValue(Object element, String property) {
        if ("Name".equals(property)) {
            if (element instanceof PatternParameter) {
                return ((PatternParameter)element).getName();
            }
        } else if ("Type".equals(property)) {
            if (element instanceof PatternParameter) {
                String type = ((PatternParameter)element).getType();
                return ParametersTableLabelProvider.getType(type);
            }
        } else if ("Query".equals(property) && element instanceof PatternParameter) {
            Query patternQuery = ((PatternParameter)element).getQuery();
            String query = patternQuery == null ? "" : patternQuery.getExtensionId();
            return query;
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        if (element instanceof TableItem) {
            element = ((TableItem)element).getData();
        }
        String text = "";
        text = value instanceof QueryKind ? ((QueryKind)value).getId() : value.toString().trim();
        PatternParameter patternParameter = (PatternParameter)element;
        if ("Name".equals(property)) {
            this.executeModify(0, patternParameter, text);
        } else if ("Type".equals(property)) {
            this.executeModify(1, patternParameter, text);
        } else if ("Query".equals(property)) {
            this.executeModify(2, patternParameter, text);
        }
    }

    private void executeModify(final int setFlag, final PatternParameter patternParameter, final String text) {
        Runnable cmd = new Runnable(){

            public void run() {
                switch (setFlag) {
                    case 0: {
                        patternParameter.setName(text);
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        ParametersTableCellModifier.this.modifyQuery(patternParameter, text);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        };
        this.doModify(cmd);
    }

    protected void modifyQuery(PatternParameter patternParameter, String text) {
        Query query = patternParameter.getQuery();
        if (text != null) {
            if (query == null && text != null && !"".equals(text)) {
                BasicQuery createBasicQuery = PatternFactory.eINSTANCE.createBasicQuery();
                createBasicQuery.setExtensionId(text);
                patternParameter.setQuery((Query)createBasicQuery);
            } else if (text != null && !"".equals(text)) {
                query.setExtensionId(text);
            } else if ("".equals(text)) {
                patternParameter.setQuery(null);
            }
        }
    }
}

